// import 'dart:math';
// import 'package:fl_chart/fl_chart.dart';
// import 'package:flutter/material.dart';
//
// /// Dữ liệu 30 ngày, mỗi phần tử là kWh (double).
// class EnergyMonthBarChart extends StatefulWidget {
//   final List<double> values;            // length 28-31 (tháng)
//   final DateTime startDate;             // ngày đầu (ví dụ: 1/9/2025)
//   final Color barColor;
//   final String unit;                    // "kWh"
//   final double? maxY;                   // nếu null sẽ auto
//   final bool showGrid;
//
//   const EnergyMonthBarChart({
//     super.key,
//     required this.values,
//     required this.startDate,
//     this.barColor = const Color(0xFF3B5AFB),
//     this.unit = 'kWh',
//     this.maxY,
//     this.showGrid = true,
//   });
//
//   @override
//   State<EnergyMonthBarChart> createState() => _EnergyMonthBarChartState();
// }
//
// class _EnergyMonthBarChartState extends State<EnergyMonthBarChart> {
//   int? _touchedIndex;
//
//   int get length => widget.values.length;
//   double get _computedMaxY {
//     final m = widget.values.fold<double>(0, (p, v) => max(p, v));
//     if (m == 0) return 10;
//     final step = 4; // nấc hiển thị
//     return (m / step).ceil() * step.toDouble() + 2; // dư chút cho đẹp
//   }
//
//   // Ngày hiện tại nằm trong dải?
//   int? get _todayIndex {
//     final today = DateTime.now();
//     final s = DateUtils.dateOnly(widget.startDate);
//     for (int i = 0; i < length; i++) {
//       final d = DateUtils.addDaysToDate(s, i);
//       if (DateUtils.isSameDay(d, today)) return i;
//     }
//     return null;
//   }
//
//   String _weekdayLabel(DateTime d) {
//     const labels = ['CN','T2','T3','T4','T5','T6','T7'];
//     return labels[d.weekday % 7];
//   }
//
//   @override
//   Widget build(BuildContext context) {
//     final theme = Theme.of(context);
//     final maxY = widget.maxY ?? _computedMaxY;
//     final sDate = DateUtils.dateOnly(widget.startDate);
//
//     // barWidth để fit 30 cột gọn trong thẻ:
//     final barWidth = 12.0;
//     final groups = List.generate(length, (i) {
//       final v = widget.values[i];
//       return BarChartGroupData(
//         x: i,
//         barRods: [
//           BarChartRodData(
//             toY: v,
//             width: barWidth,
//             borderRadius: const BorderRadius.vertical(top: Radius.circular(8)),
//             gradient: LinearGradient(
//               begin: Alignment.bottomCenter,
//               end: Alignment.topCenter,
//               colors: [
//                 widget.barColor.withOpacity(0.25),
//                 widget.barColor,
//               ],
//             ),
//           ),
//         ],
//       );
//     });
//
//     // trục dưới: hiển thị thứ & ngày (thưa để đỡ rối)
//     Widget bottomTitles(double value, TitleMeta meta) {
//       final i = value.toInt();
//       if (i < 0 || i >= length) return const SizedBox.shrink();
//       final d = DateUtils.addDaysToDate(sDate, i);
//       // hiển thị cách 2 ngày 1 lần cho gọn
//       if (i % 2 != 0) return const SizedBox.shrink();
//       final isToday = _todayIndex == i;
//       return Column(
//         mainAxisSize: MainAxisSize.min,
//         children: [
//           Text(
//             _weekdayLabel(d),
//             style: theme.textTheme.labelSmall?.copyWith(
//               color: isToday ? widget.barColor : Colors.black54,
//               fontWeight: isToday ? FontWeight.w600 : FontWeight.w400,
//             ),
//           ),
//           const SizedBox(height: 2),
//           Text(
//             '${d.day}',
//             style: theme.textTheme.labelSmall?.copyWith(
//               color: isToday ? widget.barColor : Colors.black54,
//               fontWeight: isToday ? FontWeight.w600 : FontWeight.w400,
//             ),
//           ),
//         ],
//       );
//     }
//
//     // trục trái: 0,4,8,...
//     Widget leftTitles(double value, TitleMeta meta) {
//       if (value % 4 != 0) return const SizedBox.shrink();
//       return Text(
//         value.toInt().toString(),
//         style: theme.textTheme.labelSmall?.copyWith(color: Colors.black45),
//       );
//     }
//
//     final chart = BarChart(
//       BarChartData(
//         maxY: maxY,
//         minY: 0,
//         barGroups: groups,
//         gridData: FlGridData(
//           show: widget.showGrid,
//           horizontalInterval: 4,
//           getDrawingHorizontalLine: (v) => FlLine(
//             color: Colors.black12,
//             strokeWidth: 1,
//             dashArray: [4, 4],
//           ),
//           drawVerticalLine: false,
//         ),
//         borderData: FlBorderData(show: false),
//         titlesData: FlTitlesData(
//           leftTitles: AxisTitles(
//             sideTitles: SideTitles(showTitles: true, reservedSize: 28, getTitlesWidget: leftTitles),
//           ),
//           rightTitles: const AxisTitles(sideTitles: SideTitles(showTitles: false)),
//           topTitles: const AxisTitles(sideTitles: SideTitles(showTitles: false)),
//           bottomTitles: AxisTitles(
//             sideTitles: SideTitles(
//               showTitles: true,
//               reservedSize: 34,
//               getTitlesWidget: bottomTitles,
//             ),
//           ),
//         ),
//         barTouchData: BarTouchData(
//           enabled: true,
//           handleBuiltInTouches: false, // tự custom tooltip
//           touchCallback: (evt, resp) {
//             setState(() {
//               _touchedIndex = resp?.spot?.touchedBarGroupIndex;
//             });
//             if (resp?.spot != null && evt.isInterestedForInteractions) {
//               final i = resp!.spot!.touchedBarGroupIndex;
//               final v = widget.values[i];
//               final d = DateUtils.addDaysToDate(sDate, i);
//               final text = 'Số điện: ${v.toStringAsFixed(v % 1 == 0 ? 0 : 1)} ${widget.unit}';
//               final overlay = Overlay.of(context);
//               final entry = OverlayEntry(
//                 builder: (_) => _TooltipBubble(
//                   text: text,
//                   anchor: evt.localPosition,
//                 ),
//               );
//               overlay.insert(entry);
//               Future.delayed(const Duration(milliseconds: 900), entry.remove);
//             }
//           },
//         ),
//       ),
//       swapAnimationDuration: const Duration(milliseconds: 300),
//     );
//
//     // Vạch dọc nét đứt tại ngày hiện tại (nếu nằm trong dải)
//     final todayIndex = _todayIndex;
//
//     return Container(
//       decoration: BoxDecoration(
//         color: Colors.white,
//         borderRadius: BorderRadius.circular(24),
//         boxShadow: const [BoxShadow(color: Colors.black12, blurRadius: 12, offset: Offset(0, 4))],
//       ),
//       padding: const EdgeInsets.fromLTRB(16, 16, 16, 12),
//       child: SizedBox(
//         height: 260,
//         child: LayoutBuilder(
//           builder: (ctx, cons) {
//             final chartWidget = Padding(
//               padding: const EdgeInsets.only(right: 8),
//               child: chart,
//             );
//
//             if (todayIndex == null) return chartWidget;
//
//             // Tính vị trí X ước lượng của cột today để vẽ vạch (theo tổng chiều rộng)
//             // fl_chart không expose trực tiếp nên ta ước lượng theo spacing mặc định:
//             final groupSpace = 8.0;
//             final totalW = length * barWidth + (length - 1) * groupSpace;
//             final usableW = cons.maxWidth - 28 /*left titles approx*/ - 8 /*right pad*/;
//             final scale = usableW / totalW;
//             final x = 28 + (todayIndex * (barWidth + groupSpace) + barWidth / 2) * scale;
//
//             return Stack(
//               children: [
//                 chartWidget,
//                 // vạch dọc nét đứt
//                 Positioned.fill(
//                   child: IgnorePointer(
//                     child: CustomPaint(
//                       painter: _DashedVerticalLinePainter(
//                         x: x,
//                         color: widget.barColor.withOpacity(0.5),
//                       ),
//                     ),
//                   ),
//                 ),
//               ],
//             );
//           },
//         ),
//       ),
//     );
//   }
// }
//
// /// Tooltip đơn giản đặt gần vị trí chạm
// class _TooltipBubble extends StatelessWidget {
//   final String text;
//   final Offset anchor;
//   const _TooltipBubble({required this.text, required this.anchor});
//
//   @override
//   Widget build(BuildContext context) {
//     final theme = Theme.of(context);
//     return Positioned(
//       left: anchor.dx + 8,
//       top: max(8, anchor.dy - 36),
//       child: Material(
//         color: Colors.transparent,
//         child: Container(
//           padding: const EdgeInsets.symmetric(horizontal: 10, vertical: 6),
//           decoration: BoxDecoration(
//             color: Colors.white,
//             borderRadius: BorderRadius.circular(10),
//             boxShadow: const [BoxShadow(color: Colors.black26, blurRadius: 8)],
//           ),
//           child: Text(
//             text,
//             style: theme.textTheme.labelMedium?.copyWith(fontWeight: FontWeight.w600),
//           ),
//         ),
//       ),
//     );
//   }
// }
//
// class _DashedVerticalLinePainter extends CustomPainter {
//   final double x;
//   final Color color;
//   const _DashedVerticalLinePainter({required this.x, required this.color});
//   @override
//   void paint(Canvas canvas, Size size) {
//     final paint = Paint()
//       ..color = color
//       ..strokeWidth = 2;
//     const dash = 6.0;
//     const gap = 6.0;
//     double y = 0;
//     while (y < size.height) {
//       canvas.drawLine(Offset(x, y), Offset(x, min(y + dash, size.height)), paint);
//       y += dash + gap;
//     }
//   }
//   @override
//   bool shouldRepaint(covariant _DashedVerticalLinePainter old) => old.x != x || old.color != color;
// }
