import 'package:flutter/material.dart';
import 'device_manager_model.dart';

class DeviceInfoSheet extends StatelessWidget {
  final DeviceItemModel item;
  final VoidCallback? onDelete;

  const DeviceInfoSheet({super.key, required this.item, this.onDelete});

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      top: false,
      child: Padding(
        padding: const EdgeInsets.fromLTRB(20, 24, 20, 20),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            if ((item.appName ?? '').isNotEmpty)
              Text(
                item.appName ?? '',
                textAlign: TextAlign.center,
                style: const TextStyle(fontSize: 20, fontWeight: FontWeight.w700),
              ),
            if (item.isCurrent == true)
              Container(
                padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 6),
                decoration: BoxDecoration(
                  color: Colors.green,
                  borderRadius: BorderRadius.all(Radius.circular(24)),
                ),
                child: Text(
                  'Thiết bị hiện tại',
                  style: TextStyle(fontSize: 16, color: Colors.white, fontWeight: FontWeight.w600),
                ),
              ),
            const SizedBox(height: 32),
            _InfoRow(label: 'Đăng nhập:', value: item.lastLogin ?? '-'),
            const SizedBox(height: 12),
            _InfoRow(label: 'Phương thức:', value: item.loginMethod2 ?? '-'),
            const SizedBox(height: 12),
            if ((item.location ?? '').isNotEmpty) _InfoRow(label: 'Địa điểm:', value: item.location ?? '-'),
            if ((item.location ?? '').isNotEmpty) SizedBox(height: 12),
            _InfoRow(label: 'Địa chỉ IP:', value: item.ipAddress ?? '-'),
            const SizedBox(height: 32),
            if (item.isCurrent != true)
              SizedBox(
              width: double.infinity,
              child: OutlinedButton(
                onPressed: onDelete,
                style: OutlinedButton.styleFrom(
                  side: BorderSide(color: Colors.black26),
                  padding: const EdgeInsets.symmetric(vertical: 16),
                  shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(12)),
                  foregroundColor: Colors.red,
                  textStyle: const TextStyle(fontSize: 16, fontWeight: FontWeight.w600),
                ),
                child: const Text('Xóa thiết bị'),
              ),
            ),
          ],
        ),
      ),
    );
  }
}

class _InfoRow extends StatelessWidget {
  final String label;
  final String value;

  const _InfoRow({required this.label, required this.value});

  @override
  Widget build(BuildContext context) {
    final styleLabel = TextStyle(color: Colors.grey.shade700, fontSize: 16, fontWeight: FontWeight.w600);
    const styleValue = TextStyle(fontSize: 16, fontWeight: FontWeight.w600);

    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        SizedBox(
          width: 110, // cố định để canh lề đẹp
          child: Text(label, style: styleLabel),
        ),
        const SizedBox(width: 8),
        Expanded(child: Text(value, style: styleValue)),
      ],
    );
  }
}
