class PreviewFlashSale {
  final int? id;
  final int? countdownSecond;
  final String? startTime;
  final String? endTime;
  final int? fsQuantityTotal;
  final int? fsQuantitySold;
  final int? percentTag;
  final String? rewardType;
  final String? rewardContent;
  final String? openingContent;
  final String? name;
  final String? rewardPopup;
  final int? price;
  final bool? isFlashSale;
  final bool? isFlashSalePrice;
  final String? headerImg;
  final int? fsQuantityPerPersonTotal;
  final int? fsQuantityPerPersonBought;

  const PreviewFlashSale({
    this.id,
    this.countdownSecond,
    this.startTime,
    this.endTime,
    this.fsQuantityTotal,
    this.fsQuantitySold,
    this.percentTag,
    this.rewardType,
    this.rewardContent,
    this.openingContent,
    this.name,
    this.rewardPopup,
    this.price,
    this.isFlashSale,
    this.isFlashSalePrice,
    this.headerImg,
    this.fsQuantityPerPersonTotal,
    this.fsQuantityPerPersonBought,
  });

  factory PreviewFlashSale.fromJson(Map<String, dynamic> json) {
    return PreviewFlashSale(
      id: json['id'] as int?,
      countdownSecond: json['countdown_second'] as int?,
      startTime: json['start_time'] as String?,
      endTime: json['end_time'] as String?,
      fsQuantityTotal: json['fs_quantity_total'] as int?,
      fsQuantitySold: json['fs_quantity_sold'] as int?,
      percentTag: json['percent_tag'] as int?,
      rewardType: json['reward_type'] as String?,
      rewardContent: json['reward_content'] as String?,
      openingContent: json['opening_content'] as String?,
      name: json['name'] as String?,
      rewardPopup: json['reward_popup'] as String?,
      price: json['price'] as int?,
      isFlashSale: json['is_flash_sale'] as bool?,
      isFlashSalePrice: json['is_flash_sale_price'] as bool?,
      headerImg: json['header_img'] as String?,
      fsQuantityPerPersonTotal: json['fs_quantity_per_person_total'] as int?,
      fsQuantityPerPersonBought: json['fs_quantity_per_person_bought'] as int?,
    );
  }

  Map<String, dynamic> toJson() => {
    'id': id,
    'countdown_second': countdownSecond,
    'start_time': startTime,
    'end_time': endTime,
    'fs_quantity_total': fsQuantityTotal,
    'fs_quantity_sold': fsQuantitySold,
    'percent_tag': percentTag,
    'reward_type': rewardType,
    'reward_content': rewardContent,
    'opening_content': openingContent,
    'name': name,
    'reward_popup': rewardPopup,
    'price': price,
    'is_flash_sale': isFlashSale,
    'is_flash_sale_price': isFlashSalePrice,
    'header_img': headerImg,
    'fs_quantity_per_person_total': fsQuantityPerPersonTotal,
    'fs_quantity_per_person_bought': fsQuantityPerPersonBought,
  };

  double? get progress {
    if (fsQuantityTotal != null && fsQuantitySold != null && fsQuantityTotal! > 0) {
      return fsQuantitySold! / fsQuantityTotal!;
    }
    return null;
  }

  bool get isSoldOut => fsQuantitySold == fsQuantityTotal;

  String get textQuantitySold => isSoldOut ? "Đã bán hết" : "Đã bán ${fsQuantitySold ?? 0}";

  DateTime? get startDate => _parseDate(startTime)?.subtract(Duration(seconds: 1));
  DateTime? get endDate => _parseDate(endTime)?.add(Duration(seconds: 1));

  bool? get isGoingOn {
    final now = DateTime.now();
    if (startDate != null && endDate != null && now.isBefore(endDate!)) {
      return now.isAfter(startDate!);
    }
    return null;
  }

  String? get desTime {
    final go = isGoingOn;
    if (go == null) return null;
    return go ? "Kết thúc trong" : "Bắt đầu sau";
  }

  Duration? get countdownLocal {
    final now = DateTime.now();
    if (isGoingOn == true) {
      return endDate?.difference(now);
    } else {
      return startDate?.difference(now);
    }
  }

  int? get maximumQuantityPurchased {
    if (fsQuantityPerPersonTotal != null) {
      final bought = fsQuantityPerPersonBought ?? 0;
      return (fsQuantityPerPersonTotal! - bought).clamp(0, fsQuantityPerPersonTotal!);
    }
    return null;
  }

  bool get isShowProgressSoldItemCell => isFlashSale == true && (fsQuantityTotal ?? 0) > 0;

  bool get isHidenOpeningContent =>
      openingContent == null || openingContent!.isEmpty || isGoingOn == true || isFlashSalePrice == true;

  bool get isHasReward => rewardContent != null && rewardContent!.isNotEmpty;

  String? get rewardImageAsset {
    return rewardType == "point" ? "assets/icons/ic_point.png" : "assets/icons/ic_gift_flash_sale.png";
  }

  DateTime? _parseDate(String? str) {
    if (str == null) return null;
    return DateTime.tryParse(str);
  }
}
