import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../home/models/pipi_detail_model.dart';

class PipiDetailViewModel extends RestfulApiViewModel {
  var items = RxList<PipiSupportItemModel>();

  PipiDetailViewModel();

  @override
  void onInit() {
    super.onInit();
    fetchPipiDetails();
  }

  Future<void> fetchPipiDetails() async {
    try {
      final response = await client.getPipiDetail();
      items.value = response.data?.items ?? [];
    } catch (error) {
      print("Error fetching Pipi details: $error");
    }
  }
}