import 'package:flutter/foundation.dart';
import 'web_helper.dart';

/// Example usage of closeApp functionality
class CloseAppExample {
  
  /// Close app without returning any data
  static void closeAppSimple() {
    if (kIsWeb) {
      print('🚪 Closing app (simple)...');
      webCloseApp();
    } else {
      print('⚠️ closeApp only works on web platform');
    }
  }
  
  /// Close app with success data
  static void closeAppWithSuccess() {
    if (kIsWeb) {
      print('🚪 Closing app with success data...');
      webCloseApp({
        'result': 'success',
        'message': 'Operation completed successfully',
        'timestamp': DateTime.now().millisecondsSinceEpoch,
      });
    } else {
      print('⚠️ closeApp only works on web platform');
    }
  }
  
  /// Close app with error data
  static void closeAppWithError(String errorMessage) {
    if (kIsWeb) {
      print('🚪 Closing app with error data...');
      webCloseApp({
        'result': 'error',
        'message': errorMessage,
        'timestamp': DateTime.now().millisecondsSinceEpoch,
      });
    } else {
      print('⚠️ closeApp only works on web platform');
    }
  }
  
  /// Close app with custom data
  static void closeAppWithCustomData(Map<String, dynamic> customData) {
    if (kIsWeb) {
      print('🚪 Closing app with custom data...');
      webCloseApp({
        'result': 'custom',
        'data': customData,
        'timestamp': DateTime.now().millisecondsSinceEpoch,
      });
    } else {
      print('⚠️ closeApp only works on web platform');
    }
  }
  
  /// Example: Close app after successful payment
  static void closeAppAfterPayment({
    required String transactionId,
    required double amount,
    required String currency,
  }) {
    if (kIsWeb) {
      print('🚪 Closing app after payment...');
      webCloseApp({
        'result': 'payment_success',
        'transactionId': transactionId,
        'amount': amount,
        'currency': currency,
        'timestamp': DateTime.now().millisecondsSinceEpoch,
      });
    } else {
      print('⚠️ closeApp only works on web platform');
    }
  }
  
  /// Example: Close app after form submission
  static void closeAppAfterFormSubmission({
    required String formType,
    required Map<String, dynamic> formData,
  }) {
    if (kIsWeb) {
      print('🚪 Closing app after form submission...');
      webCloseApp({
        'result': 'form_submitted',
        'formType': formType,
        'formData': formData,
        'timestamp': DateTime.now().millisecondsSinceEpoch,
      });
    } else {
      print('⚠️ closeApp only works on web platform');
    }
  }
}
