import 'package:flutter/cupertino.dart';

class MeasureSize extends StatefulWidget {
  final Widget child;
  final ValueChanged<Size> onChange;

  const MeasureSize({super.key, required this.child, required this.onChange});

  @override
  _MeasureSizeState createState() => _MeasureSizeState();
}

class _MeasureSizeState extends State<MeasureSize> {
  Size? oldSize;

  @override
  Widget build(BuildContext context) {
    WidgetsBinding.instance.addPostFrameCallback((_) {
      final contextBox = context.findRenderObject() as RenderBox?;
      if (contextBox != null && contextBox.hasSize) {
        final newSize = contextBox.size;
        if (oldSize != newSize) {
          oldSize = newSize;
          widget.onChange(newSize);
        }
      }
    });
    return widget.child;
  }
}
