#!/bin/bash

# Script để tự động thêm URL parameter handling vào index.html sau khi build

echo "🔧 Adding URL parameter handling to index.html..."

# Tìm file index.html trong build/web
INDEX_FILE="build/web/index.html"

if [ ! -f "$INDEX_FILE" ]; then
    echo "❌ File $INDEX_FILE not found!"
    exit 1
fi

# Tạo backup
cp "$INDEX_FILE" "$INDEX_FILE.backup"

       # Không cần thêm JavaScript nữa vì Flutter đọc trực tiếp từ URL
       echo "✅ No JavaScript needed - Flutter reads directly from URL query parameters"

echo "✅ Added URL parameter handling to $INDEX_FILE"

echo "🎉 Done! Now you can test with URLs like:"
echo "   http://localhost:8080/?token=abc123"
echo "   http://localhost:8080/?token=abc123&userId=user456"
