import 'package:json_annotation/json_annotation.dart';
import '../../screen/membership/models/membership_level_model.dart';

part 'working_site_model.g.dart';
@JsonSerializable()
class WorkingSiteModel {
  final String? id;
  // final String? name;
  final String? avatar;
  @JsonKey(name: 'primary_membership')
  final PrimaryMembershipModel? primaryMembership;

  WorkingSiteModel({
    this.id,
    // this.name,
    this.avatar,
    this.primaryMembership,
  });

  factory WorkingSiteModel.fromJson(Map<String, dynamic> json) => _$WorkingSiteModelFromJson(json);
  Map<String, dynamic> toJson() => _$WorkingSiteModelToJson(this);
}

@JsonSerializable()
class PrimaryMembershipModel {
  @JsonKey(name: 'membership_level')
  final MembershipLevelShortModel? membershipLevel;

  PrimaryMembershipModel({
    this.membershipLevel,
  });

  factory PrimaryMembershipModel.fromJson(Map<String, dynamic> json) => _$PrimaryMembershipModelFromJson(json);
  Map<String, dynamic> toJson() => _$PrimaryMembershipModelToJson(this);
}

@JsonSerializable()
class MembershipLevelShortModel {
  final String? levelId;
  @JsonKey(name: 'level_code')
  final String? levelCode;
  @JsonKey(name: 'level_name')
  final String? levelName;
  @JsonKey(name: 'level_logo')
  final String? levelLogo;

  MembershipLevelShortModel({
    this.levelId,
    this.levelCode,
    this.levelName,
    this.levelLogo,
  });

  factory MembershipLevelShortModel.fromJson(Map<String, dynamic> json) => _$MembershipLevelShortModelFromJson(json);
  Map<String, dynamic> toJson() => _$MembershipLevelShortModelToJson(this);
}