import 'dart:io';
import 'package:dio/dio.dart';

class ErrorMapper {
  static String map(Object e) {
    if (e is DioException) {
      switch (e.type) {
        case DioExceptionType.connectionError:
          if (e.error is SocketException) return 'Không có kết nối Internet.';
          return 'Lỗi kết nối.';
        case DioExceptionType.connectionTimeout:
        case DioExceptionType.receiveTimeout:
        case DioExceptionType.sendTimeout:
          return 'Kết nối chậm. Vui lòng thử lại.';
        case DioExceptionType.badCertificate:
          return 'Chứng chỉ không hợp lệ.';
        case DioExceptionType.cancel:
          return 'Yêu cầu đã huỷ.';
        case DioExceptionType.badResponse:
          return _extractErrorMessage(e.response?.data) ?? 'Đã xảy ra lỗi. Vui lòng thử lại!';
        case DioExceptionType.unknown:
        default:
          return 'Đã có lỗi không xác định.';
      }
    }
    if (e is SocketException) return 'Không có kết nối Internet.';
    return 'Đã có lỗi xảy ra.';
  }

  static String? _extractErrorMessage(dynamic data) {
    if (data == null) return null;
    if (data is Map<String, dynamic>) {
      return data['message']?.toString() ?? data['error_message']?.toString() ?? data['errorMessage']?.toString();
    }
    return null;
  }

  static bool isNetworkError(DioException e) {
    return e.type == DioExceptionType.connectionError ||
        e.type == DioExceptionType.connectionTimeout ||
        e.type == DioExceptionType.receiveTimeout ||
        e.type == DioExceptionType.sendTimeout ||
        e.error is SocketException;
  }
}