import 'package:dio/dio.dart';
import 'package:flutter/foundation.dart';
import 'package:mypoint_flutter_app/preference/data_preference.dart';
import 'package:uuid/uuid.dart';

class RequestInterceptor extends Interceptor {
  @override
  Future<void> onRequest(RequestOptions options, RequestInterceptorHandler handler) async {
    String authKey = 'Authorization';
    String? token = DataPreference.instance.token;
    if (token!= null) {
      options.headers[authKey] = "Bearer $token";
    }
    
    // Base headers for all platforms
    Map<String, dynamic> headers = {
      'Accept': 'application/json',
      'Content-Type': 'application/json',
      'Accept-Language': 'vi',
    };
    
    // Only add X-Request-Id for non-web platforms to avoid CORS issues
    if (!kIsWeb) {
      headers['X-Request-Id'] = Uuid().v4();
    }
    
    options.headers.addAll(headers);
    handler.next(options);
  }
}