import 'package:flutter/material.dart';
import '../../../resources/base_color.dart';
import '../model/affiliate_category_model.dart';

class AffiliateCategory extends StatelessWidget {
  final List<AffiliateCategoryModel> categories;
  final void Function(AffiliateCategoryModel)? onTap;
  const AffiliateCategory({super.key, required this.categories, this.onTap});

  @override
  Widget build(BuildContext context) {
    if (categories.isEmpty) {
      return const SizedBox.shrink();
    }
    final width = (MediaQuery.of(context).size.width - 32)/4;
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        const SizedBox(height: 24),
        Text("Lĩnh Vực Hoàn Điểm", style: TextStyle(fontWeight: FontWeight.bold, fontSize: 20)),
        const SizedBox(height: 12),
        Container(
          decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.circular(12),
            boxShadow: [BoxShadow(color: Colors.black.withOpacity(0.05), blurRadius: 5, offset: const Offset(0, 2))],
          ),
          child: GridView.count(
            padding: EdgeInsets.zero,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics(),
            crossAxisCount: 4,
            childAspectRatio: width / (width + 30),
            children: categories.map((category) => _buildAffiliateCategoryItem(category)).toList(),
          ),
        ),
      ],
    );
  }

  Widget _buildAffiliateCategoryItem(AffiliateCategoryModel category) {
    return GestureDetector(
      onTap: () {
        onTap?.call(category);
      },
      child: LayoutBuilder(
        builder: (context, constraints) {
          final double imageWidth = constraints.maxWidth / 2;
          return Container(
            padding: const EdgeInsets.only(top: 12, bottom: 8, left: 4, right: 4),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Image.asset('assets/images/cashback/${category.icon}.png', width: imageWidth, height: imageWidth,),
                const SizedBox(height: 4),
                Text(
                  category.name ?? '',
                  textAlign: TextAlign.center,
                  maxLines: 2,
                  overflow: TextOverflow.ellipsis,
                  style: const TextStyle(fontWeight: FontWeight.w600, fontSize: 16, color: BaseColor.second500),
                ),
              ],
            ),
          );
        },
      ),
    );
  }
}
