import 'package:flutter/material.dart';
import '../models/campaign_7day_config_model.dart';
import '../models/campaign_7day_mission_model.dart';

class Campaign7DayProgressBox extends StatelessWidget {
  final List<Campaign7DayMissionModel>? missions;

  const Campaign7DayProgressBox({super.key, required this.missions});

  @override
  Widget build(BuildContext context) {
    final normalMissions = missions?.where((mission) => !mission.isSpecial).toList() ?? [];
    final completedCount = (missions?.where((mission) => mission.mStatus == MissionStatus.completed).toList() ?? []).length;
    final specialMission = missions?.lastWhere((mission) => mission.isSpecial);
    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 12, vertical: 16),
      decoration: BoxDecoration(color: Colors.white, borderRadius: BorderRadius.circular(16)),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            'Hoàn thành ${normalMissions.length} nhiệm vụ để mở thưởng lớn',
            style: TextStyle(fontSize: 16, fontWeight: FontWeight.w600),
          ),
          const SizedBox(height: 12),
          Row(
            children: [
              Expanded(child: _buildLine(0 < completedCount)),
              for (int i = 0; i < (missions?.length ?? 0); i++) ...[
                _buildIcon(i < completedCount),
                Expanded(child: _buildLine(i < completedCount)),
              ],
              if (specialMission != null)
                Image.asset(
                  specialMission.mStatus == MissionStatus.completed
                      ? 'assets/images/ic_campaign_mission_gift_open.png'
                      : 'assets/images/ic_campaign_mission.png',
                  width: 48,
                  height: 48,
                ),
            ],
          ),
        ],
      ),
    );
  }

  Widget _buildIcon(bool isDone) {
    return Padding(
      padding: const EdgeInsets.symmetric(horizontal: 2),
      child: Image.asset(
        isDone ? 'assets/images/ic_point.png' : 'assets/images/ic_point_gray.png',
        width: 24,
        height: 24,
      ),
    );
  }

  Widget _buildLine(bool isDone) {
    return Container(height: 3, color: isDone ? Colors.orange : Colors.grey.shade300);
  }
}
