import 'package:flutter/material.dart';
import 'package:flutter_widget_from_html/flutter_widget_from_html.dart';
import 'package:get/get.dart';
import '../../../resources/base_color.dart';
import '../models/campaign_7day_reward_model.dart';

class Campaign7DayRewardItem extends StatelessWidget {
  final Campaign7DayRewardModel model;

  const Campaign7DayRewardItem({super.key, required this.model});

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(12),
        boxShadow: [
          BoxShadow(
            color: Colors.black.withOpacity(0.08), // màu bóng
            blurRadius: 8, // độ mờ
            offset: const Offset(0, 4), // hướng đổ bóng
          ),
        ],
      ),
      padding: const EdgeInsets.only(left: 12, right: 12, top: 12, bottom: 6),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Image.asset(model.imageAsset, width: 48, height: 48),
          const SizedBox(width: 12),
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                HtmlWidget(model.textDisplay ?? '', textStyle: const TextStyle(fontSize: 15, color: Colors.black)),
                const SizedBox(height: 8),
                Divider(color: Colors.grey.shade200, thickness: 1, height: 2),
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Expanded(child: Text(model.createdAt ?? '', style: TextStyle(fontSize: 12, color: Colors.black54))),
                    ElevatedButton(
                      onPressed: () {
                        Get.back();
                        model.direction?.begin();
                      },
                      style: ElevatedButton.styleFrom(
                        backgroundColor: BaseColor.primary400,
                        padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 2),
                        shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(24)),
                        minimumSize: const Size(0, 32),
                      ),
                      child: Text(
                        model.buttonText ?? 'Sử dụng ngay',
                        style: const TextStyle(fontSize: 14, fontWeight: FontWeight.bold, color: Colors.white),
                      ),
                    ),
                  ],
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }
}
