import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../base/base_response_model.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../../configs/constants.dart';
import '../../preference/data_preference.dart';
import '../create_pass/change_pass_repository.dart';
import '../create_pass/create_pass_screen.dart';
import '../login/login_viewmodel.dart';
import '../otp/forgot_pass_otp_repository.dart';
import '../otp/model/create_otp_response_model.dart';
import '../otp/otp_screen.dart';

class ChangePassViewModel extends RestfulApiViewModel {
  final RxBool isPasswordVisible = false.obs;
  final RxString password = "".obs;
  final Rx<LoginState> loginState = LoginState.idle.obs;
  void Function(String message)? onShowAlertError;

  void onPasswordChanged(String value) {
    password.value = value;
    if (value.isEmpty) {
      loginState.value = LoginState.idle;
    } else {
      loginState.value = LoginState.typing;
    }
  }

  void togglePasswordVisibility() {
    isPasswordVisible.value = !isPasswordVisible.value;
  }

  // void onForgotPassPressed(String phone) {
  //   callApi<CreateOTPResponseModel>(
  //     request: () => client.otpCreateNew(phone),
  //     onSuccess: (data, _) {
  //       final ttl = data.resendAfterSecond ?? Constants.otpTtl;
  //       Get.to(OtpScreen(repository: ForgotPassOTPRepository(phone, ttl)));
  //     },
  //     onFailure: (msg, _, _) async {
  //       onShowAlertError?.call(msg.isNotEmpty ? msg : Constants.commonError);
  //     },
  //   );
  // }

  Future<void> accountCheckForPasswordChange() async {
    final phone = DataPreference.instance.phone ?? "";
    await callApi<EmptyCodable>(
      request: () => client.accountLoginForPasswordChange(phone, password.value),
      onSuccess: (_, _) {
        Get.to(CreatePasswordScreen(repository: ChangePasswordRepository(phone)));
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg.isNotEmpty ? msg : Constants.commonError);
      },
    );
  }
}
