import 'package:mypoint_flutter_app/screen/quiz_campaign/quiz_campaign_screen.dart';
import '../mobile_card/models/mobile_service_redeem_data.dart';

class CheckInDataModel {
  final String? campaignCode;
  final List<Counter>? counters;

  Counter? get dailyCounter {
    return counters?.firstWhereOrNull((counter) => counter.counterName == 'CUSTOMER_CHECKIN_DAILY_TFC');
  }

  Counter? get currentCounter {
    return counters?.firstWhereOrNull((counter) => counter.counterName == 'CUSTOMER_CHECKIN_NE_TFC');
  }

  CheckInDataModel({this.campaignCode, this.counters});

  factory CheckInDataModel.fromJson(Map<String, dynamic> json) {
    return CheckInDataModel(
      campaignCode: json['campaign_code'],
      counters: (json['counters'] as List?)?.map((e) => Counter.fromJson(e)).toList(),
    );
  }
}

extension CounterExt on Counter {
  List<CounterValue> get values {
    if (counterValues is List<CounterValue>) {
      return counterValues;
    } else if (counterValues is CounterValue) {
      return [counterValues];
    } else {
      return [];
    }
  }
}

class Counter {
  final String? counterName;
  final String? counterPeriodType;
  final dynamic counterValues;

  Counter({this.counterName, this.counterPeriodType, this.counterValues});

  factory Counter.fromJson(Map<String, dynamic> json) {
    final rawValues = json['counter_values'];
    dynamic parsedValues;

    if (rawValues is List) {
      parsedValues = rawValues.map((e) => CounterValue.fromJson(e as Map<String, dynamic>)).toList();
    } else if (rawValues is Map<String, dynamic>) {
      parsedValues = CounterValue.fromJson(rawValues);
    }

    return Counter(
      counterName: json['counter_name'],
      counterPeriodType: json['counter_period_type'],
      counterValues: parsedValues,
    );
  }
}

class CounterValue {
  final String? counterValue;
  final int? pointReward;
  final String? counterPeriodValue;

  CounterValue({this.counterValue, this.pointReward, this.counterPeriodValue});

  factory CounterValue.fromJson(Map<String, dynamic> json) {
    return CounterValue(
      counterValue: json['counter_value'],
      pointReward: json['point_reward'],
      counterPeriodValue: json['counter_period_value'],
    );
  }
}

class SubmitCheckInData {
  final String? reward;
  final String? message;
  final CustomerBalance? customerBalance;

  SubmitCheckInData({this.reward, this.message, this.customerBalance});

  factory SubmitCheckInData.fromJson(Map<String, dynamic> json) {
    return SubmitCheckInData(
      reward: json['reward'] as String?,
      message: json['message'] as String?,
      customerBalance: json['customer_balance'] != null ? CustomerBalance.fromJson(json['customer_balance']) : null,
    );
  }

  Map<String, dynamic> toJson() {
    return {'reward': reward, 'message': message, 'customer_balance': customerBalance?.toJson()};
  }
}
