import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'faqs_model.dart';

class FAQViewModel extends RestfulApiViewModel {
  final RxList<PageItemModel> faqItems = <PageItemModel>[].obs;

  @override
  void onInit() {
    super.onInit();
    fetchFAQItems();
  }

  Future<void> fetchFAQItems() async {
    await callApi<FAQItemModelResponse>(
      request: () => client.websiteFolderGetPageList({"folder_uri": "FAQ"}),
      onSuccess: (data, _) {
        faqItems.assignAll(data.items ?? []);
      },
      onFailure: (_, _, _) async {
        faqItems.clear();
      },
    );
  }
}
