import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/configs/constants.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/screen/traffic_service/traffic_service_model.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'health_book_model.dart';

class HealthBookViewModel extends RestfulApiViewModel {
  final Rxn<HealthBookResponseModel> healthBookData = Rxn<HealthBookResponseModel>();
  final Rxn<HealthBookCardItemModel> healthBookDataDetail = Rxn<HealthBookCardItemModel>();
  void Function(String message)? onShowAlertError;
  final RxInt selectedIndex = 0.obs;
  late List<HeaderFilterOrderModel> headerFilterOrder;

  @override
  onInit() {
    super.onInit();
    headerFilterOrder = [
      HeaderFilterOrderModel(
        title: 'Tất cả',
        expired: '',
        suffixChecking: 'all',
        selected: true,
      ),
      HeaderFilterOrderModel(
        title: 'Hiệu lực',
        expired: "false",
        suffixChecking: 'hieuluc',
      ),
      HeaderFilterOrderModel(
        title: 'Không hiệu lực',
        expired: "true",
        suffixChecking: 'khonghieuluc',
      ),
      HeaderFilterOrderModel(
        title: 'Lượt khám',
        expired: "true",
        sort: SortFilter.asc,
        suffixChecking: 'luotkham',
      ),
    ];
  }

  Future<void> getHealthBookCards() async {
    var body = headerFilterOrder[selectedIndex.value].params;
    body['page'] = 1;
    body['size'] = 10000;
    await callApi<HealthBookResponseModel>(
      request: () => client.getHealthBookCards(body),
      onSuccess: (data, _) {
        healthBookData.value = data;
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg);
      },
    );
  }
}