import 'package:flutter/material.dart';
import 'package:mypoint_flutter_app/widgets/image_loader.dart';
import '../../voucher/sub_widget/voucher_section_title.dart';
import '../models/main_section_config_model.dart';
import '../models/my_product_model.dart';

class MyProductCarouselWidget extends StatelessWidget {
  final List<MyProductModel> items;
  final MainSectionConfigModel? sectionConfig;
  final void Function(MyProductModel)? onTap;
  const MyProductCarouselWidget({super.key, required this.items, this.sectionConfig, this.onTap});

  void _handleTapRightButton() {
    sectionConfig?.buttonViewAll?.directionalScreen?.begin();
  }

  @override
  Widget build(BuildContext context) {
    final widthItem = MediaQuery.of(context).size.width / 1.2;
    if (items.isEmpty) return const SizedBox.shrink();
    return Container(
      color: Colors.white,
      child: Column(
        children: [
          if ((sectionConfig?.name ?? "").isNotEmpty)
            HeaderSectionTitle(
              title: sectionConfig?.name ?? "",
              onViewAll: sectionConfig?.buttonViewAll?.directionalScreen != null ? _handleTapRightButton : null,
            ),
          SizedBox(
            height: widthItem * 99 / 280 + 24,
            child: ListView.separated(
              scrollDirection: Axis.horizontal,
              padding: const EdgeInsets.symmetric(horizontal: 16),
              itemCount: items.length,
              separatorBuilder: (_, __) => const SizedBox(width: 12),
              itemBuilder: (context, index) => _buildItem(context, items[index], widthItem),
            ),
          ),
        ],
      ),
    );
  }

  Widget _buildItem(BuildContext context, MyProductModel product, double widthItem) {
    return GestureDetector(
      onTap: () => onTap?.call(product),
      child: Container(
        width: widthItem,
        margin: const EdgeInsets.symmetric(vertical: 16, horizontal: 0),
        padding: const EdgeInsets.all(12),
        decoration: BoxDecoration(
          color: Colors.white,
          border: Border.all(color: Colors.grey.shade200),
          borderRadius: BorderRadius.circular(12),
          boxShadow: [BoxShadow(color: Colors.black.withOpacity(0.05), blurRadius: 6, offset: const Offset(0, 2))],
        ),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            ClipRRect(
              borderRadius: BorderRadius.circular(8),
              child: loadNetworkImage(
                url: product.logo ?? '',
                width: 64,
                height: 64,
                fit: BoxFit.cover,
                placeholderAsset: "assets/images/bg_default_11.png",
              ),
            ),
            const SizedBox(width: 16),
            Expanded(
              child: Center(
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      product.brandName ?? '',
                      style: const TextStyle(fontWeight: FontWeight.bold, fontSize: 16),
                      maxLines: 1,
                    ),
                    const SizedBox(height: 2),
                    Text(
                      product.title ?? '',
                      style: const TextStyle(fontSize: 13, color: Colors.black87),
                      maxLines: 2,
                      overflow: TextOverflow.ellipsis,
                    ),
                    const SizedBox(height: 2),
                    Text('HSD: ${product.expire ?? ''}', style: const TextStyle(fontSize: 13, color: Colors.black54)),
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
