class DistrictAddressResponse {
  final List<DistrictAddressModel>? items;

  DistrictAddressResponse({this.items});

  factory DistrictAddressResponse.fromJson(Map<String, dynamic> json) {
    return DistrictAddressResponse(
      items: (json['list_items'] as List<dynamic>?)?.map((item) => DistrictAddressModel.fromJson(item)).toList(),
    );
  }

  Map<String, dynamic> toJson() {
    return {'list_items': items?.map((item) => item.toJson()).toList()};
  }
}

class DistrictAddressModel {
  final String? countryCode2;
  final String? cityCode;
  final String? districtCode;
  final String? districtType;
  final String? districtName;
  final String? districtLatitude;
  final String? districtLongitude;

  DistrictAddressModel({
    this.countryCode2,
    this.cityCode,
    this.districtCode,
    this.districtType,
    this.districtName,
    this.districtLatitude,
    this.districtLongitude,
  });

  factory DistrictAddressModel.fromJson(Map<String, dynamic> json) {
    return DistrictAddressModel(
      countryCode2: json['country_code2'] as String?,
      cityCode: json['city_code'] as String?,
      districtCode: json['district_code'] as String?,
      districtType: json['district_type'] as String?,
      districtName: json['district_name'] as String?,
      districtLatitude: json['district_latitude'] as String?,
      districtLongitude: json['district_longitude'] as String?,
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'country_code2': countryCode2,
      'city_code': cityCode,
      'district_code': districtCode,
      'district_type': districtType,
      'district_name': districtName,
      'district_latitude': districtLatitude,
      'district_longitude': districtLongitude,
    };
  }
}
