import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../faqs/faqs_model.dart';

class NewsListViewModel extends RestfulApiViewModel {
  String folderUri;
  final RxList<PageItemModel> newsList = <PageItemModel>[].obs;
  final RxBool isLoading = false.obs;
  var _canLoadMore = true;
  int limit = 20;

  NewsListViewModel({this.folderUri = "TIN-TUC"});

  @override
  onInit() {
    super.onInit();
    getNewsList();
  }

  Future<void> getNewsList({bool isRefresh = false}) async {
    if (isLoading.value) return;
    if (!isRefresh && !_canLoadMore) return;
    isLoading(true);
    final body = {
      "folder_uri": folderUri,
      "start": isRefresh ? 0 : newsList.length,
      "limit": limit,
    };
    await callApi<FAQItemModelResponse>(
      request: () => client.websiteFolderGetPageList(body),
      onSuccess: (data, _) {
        _canLoadMore = (data.items?.length ?? 0) == limit;
        if (isRefresh) {
          newsList.clear();
        }
        newsList.addAll(data.items ?? []);
      },
      withLoading: false,
      onComplete: () {
        isLoading(false);
      }
    );
  }
}