import 'package:flutter/material.dart';
import 'package:mypoint_flutter_app/widgets/custom_app_bar.dart';
import '../../widgets/image_loader.dart';
import 'models/notification_detail_model.dart';

class NotificationDetailScreen extends StatelessWidget {
  final NotificationDetailModel notification;

  const NotificationDetailScreen({super.key, required this.notification});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CustomAppBar.back(title: "Chi tiết thông báo"),
      body: Container(
        color: Colors.grey.shade100,
        padding: const EdgeInsets.all(16),
        child: IntrinsicHeight(
          child: Container(
            padding: const EdgeInsets.all(16),
            decoration: BoxDecoration(color: Colors.white, borderRadius: BorderRadius.circular(12)),
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                ClipRRect(
                  borderRadius: BorderRadius.circular(8),
                  child: loadNetworkImage(
                    url: notification.workingSite?.avatar ?? "",
                    fit: BoxFit.cover,
                    width: 40,
                    height: 40,
                    placeholderAsset: 'assets/images/ic_logo.png',
                  ),
                ),
                const SizedBox(width: 12),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(notification.title ?? '', style: const TextStyle(fontWeight: FontWeight.bold, fontSize: 16)),
                      const SizedBox(height: 6),
                      Text(notification.body ?? '', style: const TextStyle(fontSize: 14)),
                      const SizedBox(height: 10),
                      Text(_timeAgo(notification.createTime), style: const TextStyle(color: Colors.grey, fontSize: 13)),
                    ],
                  ),
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }

  String _timeAgo(String? dateStr) {
    if (dateStr == null) return '';
    final time = DateTime.tryParse(dateStr);
    if (time == null) return '';
    final now = DateTime.now();
    final diff = now.difference(time);
    if (diff.inDays > 0) return '${diff.inDays} ngày trước';
    if (diff.inHours > 0) return '${diff.inHours} giờ trước';
    if (diff.inMinutes > 0) return '${diff.inMinutes} phút trước';
    return 'Vừa xong';
  }
}
