import 'package:flutter/material.dart';
import 'package:mypoint_flutter_app/widgets/custom_app_bar.dart';

import '../../directional/directional_screen.dart';
import '../../widgets/custom_navigation_bar.dart';

class _OrderMenuItem {
  final String title;
  final IconData icon;
  final String type;
  _OrderMenuItem({required this.title, required this.icon, required this.type});
}

class OrderMenuScreen extends StatelessWidget {
  OrderMenuScreen({super.key});

  final List<_OrderMenuItem> items = [
    _OrderMenuItem(title: 'Thẻ nạp của tôi', icon: Icons.credit_card, type: 'VIEW_MY_MOBILE_CARD'),
    _OrderMenuItem(title: 'Sổ sức khỏe điện tử', icon: Icons.medical_services_outlined, type: 'FAMILY_HEALTH_BOOK'),
    _OrderMenuItem(title: 'Dịch vụ giao thông', icon: Icons.traffic_outlined, type: 'APP_SCREEN_MY_VNTRA_PACKAGE'),
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CustomNavigationBar(title: "Đơn mua",),
      body: Container(
        color: Colors.white,
        child: ListView.separated(
          itemCount: items.length,
          separatorBuilder: (_, __) => const Divider(height: 1),
            itemBuilder: (context, index) {
              final item = items[index];
              return InkWell(
                onTap: () {
                  DirectionalScreen.build(clickActionType: item.type)?.begin();
                },
                child: Container(
                  height: 48,
                  padding: const EdgeInsets.symmetric(horizontal: 16),
                  child: Row(
                    children: [
                      Icon(item.icon, color: Colors.black54),
                      const SizedBox(width: 12),
                      Expanded(
                        child: Text(
                          item.title,
                          style: const TextStyle(fontSize: 16, color: Colors.black87),
                        ),
                      ),
                      const Icon(Icons.chevron_right, color: Colors.black54),
                    ],
                  ),
                ),
              );
            }
        ),
      ),
    );
  }
}
