import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/screen/popup_manager/popup_manager_model.dart';
import '../../networking/restful_api_viewmodel.dart';

class PopupManagerViewModel extends RestfulApiViewModel {
  PopupManagerViewModel._();
  static final PopupManagerViewModel instance = PopupManagerViewModel._();

  final Set<String> _shownIds = {};
  List<PopupManagerModel>? _popupData;
  bool _loaded = false;
  Future<void>? _loadingFuture;

  Future<void> ensureLoaded() async {
    if (_loaded) return;
    if (_loadingFuture != null) {
      return _loadingFuture;
    }
    _loadingFuture = _getPopupManagerDataInternal();
    await _loadingFuture;
  }

  Future<void> _getPopupManagerDataInternal() async {
    try {
      final response = await client.getPopupManagerCommonScreen();
      _popupData = response.data ?? [];
      // _popupData = [
      //   PopupManagerModel(
      //     id: '1',
      //     screenToShow: 'APP_SCREEN_HOME',
      //     clickActionType: 'VIEW_PRODUCT_VOUCHER',
      //     clickActionParam: '50760',
      //     posActionID: 'action1',
      //     posActionCode: 'code1',
      //     timeToShow: '10:00-18:00',
      //     timeCountDown: '30',
      //     hourStartInDay: '9',
      //     hourStopInDay: '17',
      //     afterPosID: 'pos1',
      //     afterPosCode: 'posCode1',
      //     afterPosName: 'POS Name 1',
      //     marketingRequestDescription: 'Marketing description here.',
      //     effectiveFromDate: '2023-01-01',
      //     effectiveToDate: '2023-12-31',
      //     scheduleRunTypeCode: 'daily',
      //     scheduleRunTypeName: 'Daily Schedule',
      //     scheduleAtTime: '12:00',
      //     popupTitleTemplate: 'APP_SCREEN_HOME',
      //     popupBodyTemplate: 'Enjoy your stay and check out our features.',
      //     imageID: 'image123',
      //     imageURL: 'https://picsum.photos/1200/800',
      //   ),
      //   PopupManagerModel(
      //     id: '2',
      //     screenToShow: 'APP_SCREEN_POINTBACK',
      //     clickActionType: 'APP_SCREEN_SIM_SERVICE',
      //     clickActionParam: 'https://example.com/settings',
      //     posActionID: 'action2',
      //     posActionCode: 'code2',
      //     timeToShow: '08:00-20:00',
      //     timeCountDown: '60',
      //     hourStartInDay: '8',
      //     hourStopInDay: '20',
      //     afterPosID: 'pos2',
      //     afterPosCode: 'posCode2',
      //     afterPosName: 'POS Name 2',
      //     marketingRequestDescription: 'Settings popup description.',
      //     effectiveFromDate: '2023-01-01',
      //     effectiveToDate: '2023-12-31',
      //     scheduleRunTypeCode: 'weekly',
      //     scheduleRunTypeName: 'Weekly Schedule',
      //     scheduleAtTime: '10:00',
      //     popupTitleTemplate: 'APP_SCREEN_POINTBACK',
      //     popupBodyTemplate: 'Check out the new settings options.',
      //     imageID: 'image456',
      //     imageURL: 'https://picsum.photos/1200/800',
      //   ),
      //   PopupManagerModel(
      //     id: '3',
      //     screenToShow: 'APP_SCREEN_PRODUCT_VOUCHER',
      //     clickActionType: 'APP_SCREEN_GIFTS',
      //     clickActionParam: 'Profile updated successfully.',
      //     posActionID: 'action3',
      //     posActionCode: 'code3',
      //     timeToShow: '09:00-21:00',
      //     timeCountDown: '45',
      //     hourStartInDay: '9',
      //     hourStopInDay: '21',
      //     afterPosID: 'pos3',
      //     afterPosCode: 'posCode3',
      //     afterPosName: 'POS Name 3',
      //     marketingRequestDescription: 'Profile update alert.',
      //     effectiveFromDate: '2023-01-01',
      //     effectiveToDate: '2023-12-31',
      //     scheduleRunTypeCode: 'monthly',
      //     scheduleRunTypeName: 'Monthly Schedule',
      //     scheduleAtTime: '15:00',
      //     popupTitleTemplate: 'APP_SCREEN_PRODUCT_VOUCHER',
      //     popupBodyTemplate: 'Your profile has been updated successfully.',
      //     imageID: 'image789',
      //     imageURL: 'https://picsum.photos/1200/800',
      //   ),
      //   PopupManagerModel(
      //     id: '4',
      //     screenToShow: 'APP_SCREEN_GAME_BUNDLE',
      //     clickActionType: 'APP_SCREEN_CAMPAIGN_WALKING',
      //     clickActionParam: '1',
      //     posActionID: 'action3',
      //     posActionCode: 'code3',
      //     timeToShow: '09:00-21:00',
      //     timeCountDown: '45',
      //     hourStartInDay: '9',
      //     hourStopInDay: '21',
      //     afterPosID: 'pos3',
      //     afterPosCode: 'posCode3',
      //     afterPosName: 'POS Name 3',
      //     marketingRequestDescription: 'Profile update alert.',
      //     effectiveFromDate: '2023-01-01',
      //     effectiveToDate: '2023-12-31',
      //     scheduleRunTypeCode: 'monthly',
      //     scheduleRunTypeName: 'Monthly Schedule',
      //     scheduleAtTime: '15:00',
      //     popupTitleTemplate: 'APP_SCREEN_GAME_BUNDLE',
      //     popupBodyTemplate: 'Your profile has been updated successfully.',
      //     imageID: 'image789',
      //     imageURL: 'https://picsum.photos/1200/800',
      //   ),
      //   PopupManagerModel(
      //     id: '5',
      //     screenToShow: 'APP_SCREEN_PERSONAL',
      //     clickActionType: 'APP_SCREEN_SIM_SERVICE',
      //     clickActionParam: 'Profile updated successfully.',
      //     posActionID: 'action3',
      //     posActionCode: 'code3',
      //     timeToShow: '09:00-21:00',
      //     timeCountDown: '45',
      //     hourStartInDay: '9',
      //     hourStopInDay: '21',
      //     afterPosID: 'pos3',
      //     afterPosCode: 'posCode3',
      //     afterPosName: 'POS Name 3',
      //     marketingRequestDescription: 'Profile update alert.',
      //     effectiveFromDate: '2023-01-01',
      //     effectiveToDate: '2023-12-31',
      //     scheduleRunTypeCode: 'monthly',
      //     scheduleRunTypeName: 'Monthly Schedule',
      //     scheduleAtTime: '15:00',
      //     popupTitleTemplate: 'APP_SCREEN_PERSONAL',
      //     popupBodyTemplate: 'Your profile has been updated successfully.',
      //     imageID: 'image789',
      //     imageURL: 'https://picsum.photos/1200/800',
      //   ),
      // ];
      _loaded = true;
    } catch (e) {
      _popupData = [];
      _loaded = true;
      rethrow;
    } finally {
      _loadingFuture = null;
    }
  }

  PopupManagerModel? getForScreen(String screenName) {
    if (_popupData == null || _popupData!.isEmpty) return null;
    final idx = _popupData!.indexWhere(
      (e) => (e.screenToShow ?? '').trim().toUpperCase() == screenName.trim().toUpperCase(),
    );
    if (idx < 0) return null;
    final found = _popupData![idx];
    if (_shownIds.contains(found.id)) return null;
    return found;
  }

  Future<void> markShownOnce(String popupId) async {
    _shownIds.add(popupId);
  }

  Future<void> reset() async {
    _shownIds.clear();
    _popupData = [];
    _loaded = false;
    _loadingFuture = null;
  }
}
