class TransactionCategoryModel {
  int? id;
  String? code;
  String? name;

  bool _isSelected = false;

  bool get isSelected => _isSelected;
  set isSelected(bool value) => _isSelected = value;

  TransactionCategoryModel({
    this.id,
    this.code,
    this.name,
    bool? isSelected,
  }) : _isSelected = isSelected ?? false;

  factory TransactionCategoryModel.fromJson(Map<String, dynamic> json) {
    return TransactionCategoryModel(
      id: json['id'] as int?,
      code: json['code'] as String?,
      name: json['name'] as String?,
      isSelected: json['_isSelected'] as bool? ?? false,
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'id': id,
      'code': code,
      'name': name,
      '_isSelected': _isSelected,
    };
  }
}
