import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/screen/transaction/history/transaction_history_emun.dart';
import '../../../directional/directional_action_type.dart';
import '../../../directional/directional_screen.dart';
import '../../voucher/models/product_type.dart';

part 'transaction_history_model.g.dart';
@JsonSerializable()
class TransactionHistoryModel {
  final String? id;
  @JsonKey(name: 'transaction_id')
  final String? transactionId;
  @JsonKey(name: 'item_id')
  final String? itemId;
  final String? name;
  @JsonKey(name: 'status_code')
  final String? statusCode;
  final String? status;
  @JsonKey(name: 'pay_point')
  final String? payPoint;
  @JsonKey(name: 'pay_cash')
  final String? payCash;
  final String? logo;
  @JsonKey(name: 'pay_total')
  final String? payTotal;
  @JsonKey(name: 'created_at')
  final String? createdAt;
  @JsonKey(name: 'source_cash')
  final String? sourceCash;
  @JsonKey(name: 'fees_price')
  final String? feesPrice;
  @JsonKey(name: 'product_type')
  final String? productTypeRaw;
  @JsonKey(name: 'product_info')
  final List<ProductInfoModel>? productInfo;

  TransactionHistoryModel({
    this.id,
    this.transactionId,
    this.itemId,
    this.name,
    this.statusCode,
    this.status,
    this.payPoint,
    this.payCash,
    this.logo,
    this.payTotal,
    this.createdAt,
    this.sourceCash,
    this.feesPrice,
    this.productTypeRaw,
    this.productInfo,
  });

  factory TransactionHistoryModel.fromJson(Map<String, dynamic> json) =>
      _$TransactionHistoryModelFromJson(json);
  Map<String, dynamic> toJson() => _$TransactionHistoryModelToJson(this);

  TransactionStatusOrder get statusT =>
      TransactionStatusOrder.fromRawValue(statusCode);

  bool get orderCompleted =>
      statusT == TransactionStatusOrder.success ||
          statusT == TransactionStatusOrder.failed;

  ProductType? get productType => ProductTypeExt.from(productTypeRaw) ?? ProductType.voucher;

  String get titleRedButton {
    switch (statusT) {
      case TransactionStatusOrder.success:
        switch (productType) {
          case ProductType.voucher:
            return 'Xem ưu đãi đã mua';
          case ProductType.topupMobile:
            return 'Tiếp tục nạp tiền';
          case ProductType.typeCard:
            return 'Xem thông tin thẻ';
          case ProductType.vnTra:
            return 'Xem chi tiết';
          default:
            return 'Về trang chủ';
        }
      case TransactionStatusOrder.failed:
        return 'Liên hệ hỗ trợ';
      default:
        return 'Về trang chủ';
    }
  }

  String? get titleClearButton => orderCompleted ? 'Về trang chủ' : null;
  //
  // String? get iconSupport =>
  //     statusT == TransactionStatusOrder.failed ? 'ic_support_transaction' : null;

  DirectionalScreen? get directionScreenRedButton {
    switch (statusT) {
      case TransactionStatusOrder.success:
        switch (productType) {
          case ProductType.voucher:
            return DirectionalScreen.buildByName(
              name: DirectionalScreenName.productOwnVoucher,
              clickActionParam: itemId,
            );
          case ProductType.topupMobile:
            return DirectionalScreen.buildByName(name: DirectionalScreenName.mobileTopup,);
          case ProductType.typeCard:
            return DirectionalScreen.buildByName(
              name: DirectionalScreenName.familyMedonDetailCard,
              clickActionParam: itemId,
            );
          case ProductType.vnTra:
            return DirectionalScreen.buildByName(
              name: DirectionalScreenName.detailTrafficService,
              clickActionParam: itemId,
            );
          default:
            return null;
        }
      case TransactionStatusOrder.failed:
        return DirectionalScreen.buildByName(name: DirectionalScreenName.customerSupport,);
      default:
        return null;
    }
  }
}

class ProductInfoModel {
  final String? name;
  final String? value;

  ProductInfoModel({this.name, this.value});

  factory ProductInfoModel.fromJson(Map<String, dynamic> json) {
    return ProductInfoModel(
      name: json['name'],
      value: json['value'],
    );
  }

  Map<String, dynamic> toJson() => {
    'name': name,
    'value': value,
  };
}
