import 'package:url_launcher/url_launcher.dart';

Future<void> showGoogleMap({required double? lat, required double? lng}) async {
  if (lat == null || lng == null) return;
  final googleMapsSchemeUrl = Uri.parse('comgooglemaps://');
  final googleMapsAppUrl = Uri.parse('comgooglemaps-x-callback://?saddr=&daddr=$lat,$lng&directionsmode=driving');
  final googleMapsWebUrl = Uri.parse('https://www.google.com/maps/dir/?saddr=&daddr=$lat,$lng&directionsmode=driving');

  // Kiểm tra xem device có cài app Google Maps không
  if (await canLaunchUrl(googleMapsSchemeUrl)) {
    // Có app Google Maps -> mở app
    if (await canLaunchUrl(googleMapsAppUrl)) {
      await launchUrl(googleMapsAppUrl);
    }
  } else {
    // Không có app -> mở trên trình duyệt
    if (await canLaunchUrl(googleMapsWebUrl)) {
      await launchUrl(googleMapsWebUrl, mode: LaunchMode.externalApplication);
    }
  }
}