import 'package:flutter/material.dart';

class EmptyWidget extends StatelessWidget {
  final String imageAsset;
  final String content;
  final Size size;

  const EmptyWidget({
    super.key,
    this.imageAsset = 'assets/images/ic_pipi_06.png',
    this.content = 'Không có dữ liệu hiển thị',
    this.size = const Size(200, 200),
  });

  @override
  Widget build(BuildContext context) {
    return Center(
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          Image.asset(
            imageAsset,
            width: size.width,
            height: size.height,
            fit: BoxFit.contain,
          ),
          const SizedBox(height: 16),
          Text(
            content,
            textAlign: TextAlign.center,
            style: const TextStyle(
              fontSize: 14,
              color: Colors.grey,
            ),
          ),
        ],
      ),
    );
  }
}
