import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import '../extensions/num_extension.dart';
import '../screen/voucher/models/cash_type.dart';

class CustomPointText extends StatelessWidget {
  final int point;
  final CashType? type;
  bool get isFree => point == 0;
  CurrencyUnit get currencyUnit => type == CashType.point ? CurrencyUnit.point : CurrencyUnit.vnd;

  const CustomPointText({
    super.key,
    required this.point,
    this.type,
  });

  @override
  Widget build(BuildContext context) {
    return Row(
      mainAxisSize: MainAxisSize.min,
      children: [
        Image.asset('assets/images/ic_point.png', width: 16, height: 16),
        const SizedBox(width: 4),
        Text(
          isFree ? 'Miễn phí' : point.money(currencyUnit),
          style: TextStyle(
            fontSize: 12,
            color: Colors.black,
            fontWeight: FontWeight.bold,
          ),
        ),
      ],
    );
  }
}
