import 'package:flutter/material.dart';
import '../extensions/num_extension.dart';
import '../resources/base_color.dart';
import '../screen/voucher/models/cash_type.dart';

class PriceTagWidget extends StatelessWidget {
  final int point;
  final CashType? type;
  const PriceTagWidget({super.key, required this.point, this.type,});

  bool get isFree => point == 0;
  CurrencyUnit get currencyUnit => type == CashType.point ? CurrencyUnit.point : CurrencyUnit.vnd;

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 26,
      padding: const EdgeInsets.symmetric(horizontal: 8, vertical: 2),
      decoration: BoxDecoration(
        color: BaseColor.primary150,
        borderRadius: BorderRadius.circular(13),
      ),
      child: Row(
        mainAxisSize: MainAxisSize.min,
        children: [
          Image.asset('assets/images/ic_point.png', width: 16, height: 16),
          const SizedBox(width: 4),
          Text(
            isFree ? 'Miễn phí' : point.money(currencyUnit),
            style: TextStyle(
              fontSize: 12,
              color: Colors.black,
              fontWeight: FontWeight.w500,
            ),
          ),
        ],
      ),
    );
  }
}
