import 'package:fluttertoast/fluttertoast.dart';
import 'package:flutter/material.dart';

void showToastMessage(
    String message, {
      ToastGravity gravity = ToastGravity.BOTTOM,
      Color backgroundColor = Colors.black87,
      Color textColor = Colors.white,
      int timeInSec = 2,
    }) {
  Fluttertoast.showToast(
    msg: message,
    gravity: gravity,
    backgroundColor: backgroundColor,
    textColor: textColor,
    toastLength: Toast.LENGTH_SHORT,
    timeInSecForIosWeb: timeInSec,
    fontSize: 14,
  );
}
