import 'package:flutter/material.dart';

Widget loadNetworkImage({
  required String? url,
  BoxFit fit = BoxFit.contain,
  double? width,
  double? height,
  String placeholderAsset = 'assets/images/ic_logo.png',
}) {
  if (url == null || url.isEmpty) {
    return Image.asset(
      placeholderAsset,
      fit: fit,
      width: width,
      height: height,
    );
  }

  return Image.network(
    url,
    fit: fit,
    width: width,
    height: height,
    loadingBuilder: (context, child, loadingProgress) {
      if (loadingProgress == null) return child;
      return Center(
        child: SizedBox(
          width: 24,
          height: 24,
          child: CircularProgressIndicator(
            strokeWidth: 2,
            value: loadingProgress.expectedTotalBytes != null
                ? loadingProgress.cumulativeBytesLoaded /
                loadingProgress.expectedTotalBytes!
                : null,
          ),
        ),
      );
    },
    errorBuilder: (context, error, stackTrace) {
      return Image.asset(
        placeholderAsset,
        fit: fit,
        width: width,
        height: height,
      );
    },
  );
}
