// import 'package:flutter/material.dart';
// import 'package:intl/intl.dart';
//
// class DatePickerField extends StatefulWidget {
//   final String label;
//   final DateTime? initialDate;
//   final Function(DateTime) onDateSelected;
//   final bool enabled;
//
//   const DatePickerField({
//     super.key,
//     required this.label,
//     this.initialDate,
//     required this.onDateSelected,
//     this.enabled = true,
//   });
//
//   @override
//   State<DatePickerField> createState() => _DatePickerFieldState();
// }
//
// class _DatePickerFieldState extends State<DatePickerField> {
//   DateTime? _selectedDate;
//
//   @override
//   void initState() {
//     super.initState();
//     _selectedDate = widget.initialDate;
//   }
//
//   Future<void> _pickDate() async {
//     if (!widget.enabled) return;
//
//     final now = DateTime.now();
//     final picked = await showDatePicker(
//       context: context,
//       initialDate: _selectedDate ?? now,
//       firstDate: DateTime(1900),
//       lastDate: DateTime(2100),
//     );
//
//     if (picked != null) {
//       setState(() {
//         _selectedDate = picked;
//       });
//       widget.onDateSelected(picked);
//     }
//   }
//
//   @override
//   Widget build(BuildContext context) {
//     final displayText = _selectedDate != null
//         ? DateFormat('dd/MM/yyyy').format(_selectedDate!)
//         : widget.label;
//
//     return GestureDetector(
//       onTap: _pickDate,
//       child: AbsorbPointer(
//         child: Container(
//           padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
//           decoration: BoxDecoration(
//             border: Border.all(color: Colors.grey.shade400),
//             borderRadius: BorderRadius.circular(8),
//             color: widget.enabled ? Colors.white : Colors.grey.shade100,
//           ),
//           child: Row(
//             children: [
//               const Icon(Icons.calendar_today, color: Colors.blueGrey, size: 20),
//               const SizedBox(width: 12),
//               Expanded(
//                 child: Text(
//                   displayText,
//                   style: TextStyle(
//                     fontSize: 16,
//                     color: _selectedDate != null
//                         ? Colors.black87
//                         : Colors.grey.shade500,
//                   ),
//                 ),
//               ),
//               if (widget.enabled)
//                 const Icon(Icons.expand_more, color: Colors.grey),
//             ],
//           ),
//         ),
//       ),
//     );
//   }
// }
