"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtractorMessageId = exports.ExtractorMessageCategory = exports.ExtractorMessage = exports.ExtractorLogLevel = exports.ExtractorConfig = exports.ExtractorResult = exports.Extractor = exports.CompilerState = exports.ConsoleMessageId = void 0;
/**
 * API Extractor helps with validation, documentation, and reviewing of the exported API for a TypeScript library.
 * The `@microsoft/api-extractor` package provides the command-line tool.  It also exposes a developer API that you
 * can use to invoke API Extractor programmatically.
 *
 * @packageDocumentation
 */
var ConsoleMessageId_1 = require("./api/ConsoleMessageId");
Object.defineProperty(exports, "ConsoleMessageId", { enumerable: true, get: function () { return ConsoleMessageId_1.ConsoleMessageId; } });
var CompilerState_1 = require("./api/CompilerState");
Object.defineProperty(exports, "CompilerState", { enumerable: true, get: function () { return CompilerState_1.CompilerState; } });
var Extractor_1 = require("./api/Extractor");
Object.defineProperty(exports, "Extractor", { enumerable: true, get: function () { return Extractor_1.Extractor; } });
Object.defineProperty(exports, "ExtractorResult", { enumerable: true, get: function () { return Extractor_1.ExtractorResult; } });
var ExtractorConfig_1 = require("./api/ExtractorConfig");
Object.defineProperty(exports, "ExtractorConfig", { enumerable: true, get: function () { return ExtractorConfig_1.ExtractorConfig; } });
var ExtractorLogLevel_1 = require("./api/ExtractorLogLevel");
Object.defineProperty(exports, "ExtractorLogLevel", { enumerable: true, get: function () { return ExtractorLogLevel_1.ExtractorLogLevel; } });
var ExtractorMessage_1 = require("./api/ExtractorMessage");
Object.defineProperty(exports, "ExtractorMessage", { enumerable: true, get: function () { return ExtractorMessage_1.ExtractorMessage; } });
Object.defineProperty(exports, "ExtractorMessageCategory", { enumerable: true, get: function () { return ExtractorMessage_1.ExtractorMessageCategory; } });
var ExtractorMessageId_1 = require("./api/ExtractorMessageId");
Object.defineProperty(exports, "ExtractorMessageId", { enumerable: true, get: function () { return ExtractorMessageId_1.ExtractorMessageId; } });
//# sourceMappingURL=index.js.map