#!/bin/bash

set -euo pipefail

SRC="node_modules/x-app-sdk/dist/index.es.js"
DEST_DEFAULT="build/web/js/x_app_sdk_bundle.js"

DEST="${1:-$DEST_DEFAULT}"

if [ ! -f "$SRC" ]; then
  echo "❌ x-app-sdk bundle not found at $SRC" >&2
  exit 1
fi

mkdir -p "$(dirname "$DEST")"
cp "$SRC" "$DEST"

echo "✅ Copied x-app-sdk bundle to $DEST"
