import 'package:intl/intl.dart';

extension NumExtension on num {
  String money([CurrencyUnit currency = CurrencyUnit.vnd]) {
    final int maximumFractionDigits =
    (currency == CurrencyUnit.vnd) ? 0 : 2;
    return "${numberFraction(maximumFractionDigits)}${currency.symbol}";
  }

  String numberFraction(int maxFractionDigits) {
    final formatter = NumberFormat.decimalPattern('vi_VN')
      ..maximumFractionDigits = maxFractionDigits
      ..minimumFractionDigits = 0;
    return formatter.format(this);
  }

  String formatCompactNumber() {
    if (this < 1000) {
      return toString();
    } else if (this < 1000000) {
      return '${(this / 1000).toStringAsFixed(1)}K';
    } else if (this < 1000000000) {
      return '${(this / 1000000).toStringAsFixed(1)}M';
    } else {
      return '${(this / 1000000000).toStringAsFixed(1)}B';
    }
  }
}

enum CurrencyUnit {
  vnd('đ'),
  usd(' USD'),
  eur(' EUR'),
  none(' '),
  noneSpace(''),
  VND(' VNĐ'),
  point(' điểm');
  final String symbol;
  const CurrencyUnit(this.symbol);
}