import 'package:flutter/foundation.dart';
import 'package:get/get.dart';
import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/shared/navigation/directional_screen.dart';

part 'achievement_model.g.dart';
@JsonSerializable()
class AchievementModel {
  final String? id;
  @JsonKey(name: 'achievement_name')
  final String? achievementName;
  @JsonKey(name: 'achievement_icon_url')
  final String? achievementIconUrl;
  @JsonKey(name: 'apply_for_group')
  final String? applyForGroup;
  @JsonKey(name: 'click_action_type')
  final String? clickActionType;
  @JsonKey(name: 'click_action_param')
  final String? clickActionParam;
  final List<AchievementImageModel>? images;

  const AchievementModel({
    this.id,
    this.achievementName,
    this.achievementIconUrl,
    this.applyForGroup,
    this.clickActionType,
    this.clickActionParam,
    this.images,
  });

  DirectionalScreen? get directionScreen {
    return DirectionalScreen.build(
      clickActionType: clickActionType,
      clickActionParam: clickActionParam,
    );
  }

  String? get urlBackground {
    final coverImage = images?.firstWhereOrNull(
      (image) => image.imageType == 'COVER',
    );
    final url = coverImage?.imageUrl ?? images?.firstOrNull?.imageUrl;
    debugPrint("urlBackground: $url");
    return url;
  }

  factory AchievementModel.fromJson(Map<String, dynamic> json) =>
      _$AchievementModelFromJson(json);
  Map<String, dynamic> toJson() => _$AchievementModelToJson(this);
}

@JsonSerializable()
class AchievementImageModel {
  final String? id;
  @JsonKey(name: 'image_type')
  final String? imageType;
  @JsonKey(name: 'image_url')
  final String? imageUrl;

  const AchievementImageModel({
    this.id,
    this.imageType,
    this.imageUrl,
  });

  factory AchievementImageModel.fromJson(Map<String, dynamic> json) =>
      _$AchievementImageModelFromJson(json);
  Map<String, dynamic> toJson() => _$AchievementImageModelToJson(this);
}

class AchievementListResponse {
  final List<AchievementModel>? achievements;
  const AchievementListResponse({this.achievements});

  factory AchievementListResponse.fromJson(Map<String, dynamic> json) {
    return AchievementListResponse(
      achievements: (json['achievements'] as List?)
          ?.map((e) => AchievementModel.fromJson(e as Map<String, dynamic>))
          .toList(),
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'achievements': achievements?.map((e) => e.toJson()).toList(),
    };
  }
}