import 'package:flutter/material.dart';
import '../models/campaign_7day_config_model.dart';
import '../models/campaign_7day_mission_model.dart';

class Campaign7DaySpecialMissionCard extends StatelessWidget {
  final Campaign7DayMissionModel mission;
  final VoidCallback? onTap;

  const Campaign7DaySpecialMissionCard({
    super.key,
    required this.mission,
    this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    final width = MediaQuery.of(context).size.width;
    final height = (width)*300/957;
    final imagePath = makeImageBGSubmitMission(mission.mStatus);
    return GestureDetector(
      onTap: onTap,
      child: Container(
        width: width,
        height: height,
        margin: const EdgeInsets.symmetric(horizontal: 0, vertical: 4),
        decoration: BoxDecoration(
          image: DecorationImage(
            image: AssetImage(imagePath),
            fit: BoxFit.contain,
          ),
        ),
        padding: const EdgeInsets.symmetric(horizontal: 16),
        child: Row(
          children: [
            Expanded(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    mission.title ?? '',
                    style: const TextStyle(
                      fontSize: 17,
                      fontWeight: FontWeight.w800,
                      color: Colors.white,
                      shadows: [
                        Shadow(
                          offset: Offset(2, 2),
                          blurRadius: 0.1,
                          color: Colors.black54,
                        ),
                      ],
                    ),
                  ),
                  const SizedBox(height: 2),
                  Text(
                    mission.description ?? '',
                    style: const TextStyle(
                      fontSize: 14,
                      color: Colors.white,
                    ),
                  ),
                ],
              ),
            ),
            SizedBox(width: width/4.5,),
          ],
        ),
      ),
    );
  }

  String makeImageBGSubmitMission(MissionStatus status) {
    late final String imageName;
    switch (status) {
      case MissionStatus.ready:
        imageName = 'assets/images/bg_misstion_submit_campaign_7day_ready.png';
        break;
      case MissionStatus.pending:
        imageName = 'assets/images/bg_misstion_submit_campaign_7day_disable.png';
        break;
      case MissionStatus.completed:
        imageName = 'assets/images/bg_misstion_submit_campaign_7day_complete.png';
        break;
    }
    return imageName;
  }
}
