import 'dart:ui';
import 'package:json_annotation/json_annotation.dart';
import '../../../core/theme/base_color.dart';

part 'campaign_7day_config_model.g.dart';
@JsonSerializable()
class Campaign7dayConfigModel {
  @JsonKey(name: 'main_icon')
  final String? mainIcon;
  @JsonKey(name: 'progress_bar_text')
  final String? progressBarText;
  @JsonKey(name: 'header_img')
  final String? headerImg;
  @JsonKey(name: 'main_color')
  final String? mainColorHex;
  @JsonKey(name: 'main_img_type')
  final String? mainImgType;

  Campaign7dayConfigModel({
    this.mainIcon,
    this.progressBarText,
    this.headerImg,
    this.mainColorHex,
    this.mainImgType,
  });

  factory Campaign7dayConfigModel.fromJson(Map<String, dynamic> json) =>
      _$Campaign7dayConfigModelFromJson(json);
  Map<String, dynamic> toJson() => _$Campaign7dayConfigModelToJson(this);

  String get suffixImageName {
    final style = CampaignStyleImage.values.firstWhere(
          (e) => e.name.toUpperCase() == (mainImgType ?? '').toUpperCase(),
      orElse: () => CampaignStyleImage.RED,
    );
    return style.name;
  }

  Color get mainColor {
    if ((mainColorHex ?? '').isEmpty) {
      return BaseColor.primary400;
    }
    return _parseHexColor(mainColorHex!) ?? BaseColor.primary400;
  }

  String get headerMissionBGAsset =>
      'assets/images/bg_header_alert_campaign_7day_$suffixImageName.png';

  Color? _parseHexColor(String hex) {
    try {
      final buffer = StringBuffer();
      if (hex.startsWith('#')) hex = hex.substring(1);
      if (hex.length == 6) buffer.write('ff');
      buffer.write(hex);
      return Color(int.parse(buffer.toString(), radix: 16));
    } catch (_) {
      return null;
    }
  }
}

enum MissionStatus { ready, pending, completed }
enum TypeReward { point, voucher }
enum CampaignStyleImage { RED, ORANGE }