import 'package:flutter/foundation.dart';
import 'package:json_annotation/json_annotation.dart';
import 'campaign_7day_config_model.dart';
import 'campaign_7day_mission_model.dart';
import 'package:intl/intl.dart' as intl;

part 'campaign_7day_info_model.g.dart';
@JsonSerializable()
class Campaign7DayInfoModel {
  final int id;
  final String? description;
  final String? icon;
  @JsonKey(name: 'start_time')
  final String? startTime;
  @JsonKey(name: 'end_time')
  final String? endTime;
  final List<Campaign7DayMissionModel>? missions;
  final String? name;
  final Campaign7dayConfigModel? config;

  Campaign7DayInfoModel({
    required this.id,
    this.description,
    this.icon,
    this.startTime,
    this.endTime,
    this.missions,
    this.name,
    this.config,
  });

  double? get countDownTime {
    debugPrint("End time: $endTime");
    if (endTime == null) return null;
    try {
      final date = intl.DateFormat("yyyy-MM-dd HH:mm:ss").parseUtc(endTime!);
      debugPrint("Parsed date: $date");
      final now = DateTime.now().toUtc();
      final diff = date.difference(now).inSeconds;
      debugPrint("Difference in seconds: $diff");
      return (diff > 0 ? diff : 0).toDouble();
    } catch (_) {
      return null;
    }
  }

  factory Campaign7DayInfoModel.fromJson(Map<String, dynamic> json) =>
      _$Campaign7DayInfoModelFromJson(json);
  Map<String, dynamic> toJson() => _$Campaign7DayInfoModelToJson(this);
}