import 'package:json_annotation/json_annotation.dart';

part 'electric_payment_response_model.g.dart';
@JsonSerializable()
class ElectricPaymentResponseModel {
  @JsonKey(name: 'request_id')
  final String? requestId;
  @JsonKey(name: 'vitapay_status')
  final String? vitapayStatus;
  @JsonKey(name: 'vitapay_message')
  final String? vitapayMessage;
  @JsonKey(name: 'vitapay_amount')
  final double? vitapayAmount;
  @JsonKey(name: 'vitapay_datatype')
  final String? vitapayDatatype;
  @JsonKey(name: 'vitapay_data')
  final String? vitapayData;
  @JsonKey(name: 'item_ids')
  final String? itemIds;

  ElectricPaymentResponseModel({
    this.requestId,
    this.vitapayStatus,
    this.vitapayMessage,
    this.vitapayAmount,
    this.vitapayDatatype,
    this.vitapayData,
    this.itemIds,
  });

  factory ElectricPaymentResponseModel.fromJson(Map<String, dynamic> json) =>
      _$ElectricPaymentResponseModelFromJson(json);

  Map<String, dynamic> toJson() => _$ElectricPaymentResponseModelToJson(this);
}
