import 'package:json_annotation/json_annotation.dart';

part 'faqs_model.g.dart';
@JsonSerializable()
class PageItemModel {
  final String? thumbnail;
  @JsonKey(name: "page_id")
  final String? pageId;
  final String? title;
  @JsonKey(name: "publish_at_date")
  final String? publishAtDate;
  final String? chapeau;

  PageItemModel({
    this.thumbnail,
    this.pageId,
    this.title,
    this.publishAtDate,
    this.chapeau,
  });

  factory PageItemModel.fromJson(Map<String, dynamic> json) => _$PageItemModelFromJson(json);
  Map<String, dynamic> toJson() => _$PageItemModelToJson(this);
}

@JsonSerializable()
class FAQItemModelResponse {
  final List<PageItemModel>? items;

  FAQItemModelResponse({
    this.items,
  });

  factory FAQItemModelResponse.fromJson(Map<String, dynamic> json) => _$FAQItemModelResponseFromJson(json);
  Map<String, dynamic> toJson() => _$FAQItemModelResponseToJson(this);
}