import 'package:get/get.dart';
import 'package:mypoint_flutter_app/core/network/api/website_api.dart' deferred as website_api;
import '../../core/network/restful_api_viewmodel.dart';
import 'faqs_model.dart';

class FAQViewModel extends RestfulApiViewModel {
  final RxList<PageItemModel> faqItems = <PageItemModel>[].obs;

  bool _websiteApiLoaded = false;

  Future<void> _ensureWebsiteApiLoaded() async {
    if (_websiteApiLoaded) return;
    await website_api.loadLibrary();
    _websiteApiLoaded = true;
  }

  @override
  void onInit() {
    super.onInit();
    fetchFAQItems();
  }

  Future<void> fetchFAQItems() async {
    await callApi<FAQItemModelResponse>(
      request: () async {
        await _ensureWebsiteApiLoaded();
        final api = website_api.WebsiteApi(client);
        return api.websiteFolderGetPageList({"folder_uri": "FAQ"});
      },
      onSuccess: (data, _) {
        faqItems.assignAll(data.items ?? []);
      },
      onFailure: (_, _, _) async {
        faqItems.clear();
      },
    );
  }
}
