import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/features/flash_sale/models/preview_flash_sale_model.dart';
import 'package:mypoint_flutter_app/features/voucher/models/product_model.dart';

part 'flash_sale_detail_response.g.dart';
@JsonSerializable()
class FlashSaleDetailResponse {
  final int? id;
  @JsonKey(name: 'flash_sale')
  final PreviewFlashSale? flashSale;
  final List<ProductModel>? products;
  final String? name;
  @JsonKey(name: 'countdown_second')
  final int? countdownSecond;
  @JsonKey(name: 'header_img')
  final String? headerImg;
  @JsonKey(name: 'start_time')
  final String? startTime;
  @JsonKey(name: 'end_time')
  final String? endTime;
  @JsonKey(name: 'is_reward')
  final bool? isReward;

  FlashSaleDetailResponse({
    this.id,
    this.flashSale,
    this.products,
    this.name,
    this.countdownSecond,
    this.headerImg,
    this.startTime,
    this.endTime,
    this.isReward,
  });

  factory FlashSaleDetailResponse.fromJson(Map<String, dynamic> json) =>
      _$FlashSaleDetailResponseFromJson(json);

  Map<String, dynamic> toJson() => _$FlashSaleDetailResponseToJson(this);
}
