import 'dart:ui';

class CashHistoryModel {
  final String? cashTitle;
  final String? orderStatus;
  final String? total;
  final String? transactionDatetime;

  CashOrderStatus get status => CashOrderStatus.fromRaw(orderStatus ?? '0');

  CashHistoryModel({
    this.cashTitle,
    this.orderStatus,
    this.total,
    this.transactionDatetime,
  });

  factory CashHistoryModel.fromJson(Map<String, dynamic> json) {
    return CashHistoryModel(
      cashTitle: json['cash_title'] as String?,
      orderStatus: json['order_status'] as String?,
      total: json['total'] as String?,
      transactionDatetime: json['transaction_datetime'] as String?,
    );
  }

  Map<String, dynamic> toJson() => {
        'cash_title': cashTitle,
        'order_status': orderStatus,
        'total': total,
        'transaction_datetime': transactionDatetime,
      };
}

enum CashOrderStatus {
  processing, success, rejected;

  static CashOrderStatus fromRaw(String raw, {CashOrderStatus fallback = CashOrderStatus.processing}) {
    final i = int.tryParse(raw.trim());
    return (i != null && i >= 0 && i < CashOrderStatus.values.length)
        ? CashOrderStatus.values[i]
        : fallback;
  }

  String get title => switch (this) {
    CashOrderStatus.processing => 'Đang chờ',
    CashOrderStatus.success    => 'Thành công',
    CashOrderStatus.rejected   => 'Đã hủy',
  };

  Color get color => switch (this) {
    CashOrderStatus.processing => const Color(0xFFFF7527), // h_FF7527
    CashOrderStatus.success    => const Color(0xFF04AF5D), // h_04AF5D
    CashOrderStatus.rejected   => const Color(0xFFD42230), // h_D42230
  };
}
