import 'package:flutter/material.dart';
import '../../shared/widgets/bottom_sheet_helper.dart';
import '../../shared/widgets/custom_navigation_bar.dart';
import '../delete_account/delete_account_dialog.dart';

class AccountManagerScreen extends StatefulWidget {
  const AccountManagerScreen({super.key});

  @override
  State<AccountManagerScreen> createState() => _AccountManagerScreenState();
}

class _AccountManagerScreenState extends State<AccountManagerScreen> {

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CustomNavigationBar(title: "Quản lý tài khoản"),
      backgroundColor: const Color(0xFFF5F6F7),
      body: Column(
        children: [
          Container(
            width: double.infinity,
            margin: const EdgeInsets.symmetric(horizontal: 0, vertical: 0),
            decoration: BoxDecoration(
              color: Colors.white,
            ),
            child: Column(
              children: [
                  _buildSettingItem(
                    icon: Icons.delete_outline,
                    title: 'Xóa tài khoản',
                    onTap: () {
                      BottomSheetHelper.showBottomSheetPopup(
                        child: const DeleteAccountDialog(),
                      );
                    },
                    textColor: Colors.red,
                    iconColor: Colors.red,
                    showTrailing: false,
                  ),
              ],
            ),
          ),
          const Expanded(child: SizedBox()),
        ],
      ),
    );
  }

  Widget _buildSettingItem({
    required IconData icon,
    required String title,
    required VoidCallback onTap,
    Widget? trailing,
    Color? textColor,
    Color? iconColor,
    bool showTrailing = true,
  }) {
    return ListTile(
      leading: Icon(icon, color: iconColor ?? Colors.black54),
      title: Text(
        title,
        style: TextStyle(
          fontSize: 16,
          color: textColor ?? Colors.black87,
          fontWeight: FontWeight.w500,
        ),
      ),
      trailing: trailing ?? (showTrailing ? const Icon(Icons.chevron_right, color: Colors.black26) : null),
      onTap: onTap,
      contentPadding: const EdgeInsets.symmetric(horizontal: 16),
    );
  }
}