import 'package:json_annotation/json_annotation.dart';

enum SupportItemType { mail, phone, facebook, question, termsOfUse, privacyPolicy }

@JsonSerializable()
class SupportItemModel {
  final String icon;
  final String title;
  final String value;
  final SupportItemType type;

  SupportItemModel({
    required this.icon,
    required this.title,
    required this.value,
    required this.type,
  });

  factory SupportItemModel.fromJson(Map<String, dynamic> json) {
    return SupportItemModel(
      icon: json["icon"],
      title: json["title"],
      value: json["value"],
      type: _mapStringToType(json["type"]),
    );
  }

  static SupportItemType _mapStringToType(String type) {
    switch (type) {
      case "mail":
        return SupportItemType.mail;
      case "phone":
        return SupportItemType.phone;
      case "facebook":
        return SupportItemType.facebook;
      case "question":
        return SupportItemType.question;
      case "termsOfUse":
        return SupportItemType.termsOfUse;
      case "privacyPolicy":
        return SupportItemType.privacyPolicy;
      default:
        throw Exception("Loại không hợp lệ: $type");
    }
  }
}
