enum ProductType {
  voucher,
  topupMobile,
  topupData,
  mobileCard,
  offline,
  typeCard,
  vnTra,
}

extension ProductTypeExt on ProductType {
  String get value {
    switch (this) {
      case ProductType.voucher:
        return 'PRODUCT_TYPE_VOUCHER';
      case ProductType.topupMobile:
        return 'PRODUCT_TYPE_TOPUP_MOBILE';
      case ProductType.topupData:
        return 'PRODUCT_TYPE_TOPUP_DATA';
      case ProductType.mobileCard:
        return 'PRODUCT_TYPE_MOBILE_CARD';
      case ProductType.offline:
        return 'PRODUCT_TYPE_OFFLINE';
      case ProductType.typeCard:
        return 'PRODUCT_TYPE_CARD';
      case ProductType.vnTra:
        return 'PRODUCT_TYPE_VNTRA_PACKAGE';
    }
  }

  /// Parse từ String về enum
  static ProductType? from(String? raw) {
    switch (raw) {
      case 'PRODUCT_TYPE_VOUCHER':
        return ProductType.voucher;
      case 'PRODUCT_TYPE_TOPUP_MOBILE':
        return ProductType.topupMobile;
      case 'PRODUCT_TYPE_TOPUP_DATA':
        return ProductType.topupData;
      case 'PRODUCT_TYPE_MOBILE_CARD':
        return ProductType.mobileCard;
      case 'PRODUCT_TYPE_OFFLINE':
        return ProductType.offline;
      case 'PRODUCT_TYPE_CARD':
        return ProductType.typeCard;
      case 'PRODUCT_TYPE_VNTRA_PACKAGE':
        return ProductType.vnTra;
      default:
        return null;
    }
  }
}
