import 'package:get/get.dart';
import '../app/routing/deferred_routes.dart';
import '../features/game/game_cards/game_card_screen.dart';
import '../features/game/game_tab_screen.dart';
import '../features/login/login_screen.dart';
import '../features/main_tab_screen/main_tab_screen.dart';
import '../features/notification/notification_detail_screen.dart';
import '../features/notification/notification_screen.dart';
import '../features/onboarding/onboarding_screen.dart';
import '../features/pageDetail/campaign_detail_screen.dart';
import '../features/personal/personal_edit_screen.dart';
import '../features/register_campaign/register_form_input_screen.dart';
import '../features/setting/account_manager_screen.dart';
import '../features/setting/setting_screen.dart';
import '../features/splash/splash_screen.dart';
import '../features/voucher/voucher_list/voucher_list_screen.dart';
import '../features/webview/web_view_screen.dart';
const splashScreen = '/splash';
const onboardingScreen = '/onboarding';
const loginScreen = '/login';
const mainScreen = '/main';
const settingScreen = '/setting';
const flashSaleScreen = '/flashSale';
const vouchersScreen = '/vouchers';
const voucherDetailScreen = '/voucherDetail';
const gameCardScreen = '/gameCardScreen';
const registerFormInputScreen = '/registerFormInputScreen';
const transactionDetailScreen = '/transactionDetailScreen';
const baseWebViewScreen = '/baseWebViewScreen';
const paymentWebViewScreen = '/paymentWebViewScreen';
const transactionHistoryDetailScreen = '/transactionHistoryDetailScreen';
const supportScreen = '/supportScreen';
const notificationScreen = '/notificationScreen';
const campaignDetailScreen = '/campaignDetailScreen';
const newsListScreen = '/newsListScreen';
const achievementListScreen = '/achievementListScreen';
const vplayGameCenterScreen = '/vplayGameCenterScreen';
const myVoucherListScreen = '/myVoucherListScreen';
const personalEditScreen = '/personalEditScreen';
const orderMenuScreen = '/orderMenuScreen';
const locationAddressScreen = '/locationAddressScreen';
const membershipScreen = '/membershipScreen';
const phoneTopUpScreen = '/phoneTopUpScreen';
const productMobileCardScreen = '/productMobileCardScreen';
const dataNetworkServiceScreen = '/dataNetworkServiceScreen';
const affiliateTabScreen = '/affiliateTabScreen';
const gameTabScreen = '/gameTabScreen';
const historyPointCashBackScreen = '/historyPointCashBackScreen';
const affiliateBrandDetailScreen = '/affiliateBrandDetailScreen';
const affiliateBrandListScreen = '/affiliateBrandListScreen';
const affiliateCategoryGridScreen = '/affiliateCategoryGridScreen';
const inviteFriendCampaignScreen = '/inviteFriendCampaignScreen';
const contactsListScreen = '/contactsListScreen';
const dailyCheckInScreen = '/dailyCheckInScreen';
const transactionHistoryScreen = '/transactionHistoryScreen';
const electricPaymentScreen = '/electricPaymentScreen';
const electricPaymentHistoryScreen = '/electricPaymentHistoryScreen';
const trafficServiceScreen = '/trafficServiceScreen';
const trafficServiceDetailScreen = '/trafficServiceDetailScreen';
const healthBookScreen = '/healthBookScreen';
const campaignSevenDayScreen = '/campaignSevenDayScreen';
const surveyQuestionScreen = '/surveyQuestionScreen';
const deviceManagerScreen = '/deviceManagerScreen';
const interestCategoriesScreen = '/interestCategoriesScreen';
const myMobileCardListScreen = '/myMobileCardListScreen';
const bankAccountManagerScreen = '/bankAccountManagerScreen';
const historyPointScreen = '/historyPointScreen';
const qrCodeScreen = '/qrCodeScreen';
const myMobileCardDetailScreen = '/myMobileCardDetailScreen';
const healthBookCardDetail = '/healthBookCardDetail';
const notificationDetailScreen = '/notificationDetailScreen';
const referralCodeInviteFriendScreen = '/referralCodeInviteFriendScreen';
const campaignInviteReferralInfoScreen = '/campaignInviteReferralInfoScreen';
const accountManagerScreen = '/accountManagerScreen';

class RouterPage {
  static List<GetPage> pages() {
    List<GetPage> list = [];
    list.addAll(_pages());
    return list;
  }

  static List<GetPage> _pages() {
    return [
      GetPage(name: splashScreen, page: () => SplashScreen()),
      GetPage(name: onboardingScreen, page: () => OnboardingScreen()),
      GetPage(name: loginScreen, page: () => LoginScreen()),
      GetPage(
        name: mainScreen,
        page: () => MainTabScreen(),
        participatesInRootNavigator: true,
        fullscreenDialog: true,
        binding: BindingsBuilder(() {}),
      ),
      GetPage(name: settingScreen, page: () => SettingScreen()),
      GetPage(name: vouchersScreen, page: () => VoucherListScreen()),
      GetPage(name: flashSaleScreen, page: () => const FlashSaleDeferredScreen()),
      GetPage(name: voucherDetailScreen, page: () => const VoucherDetailDeferredScreen()),
      GetPage(name: gameCardScreen, page: () => const GameCardScreen()),
      GetPage(name: registerFormInputScreen, page: () => RegisterFormInputScreen()),
      GetPage(name: transactionDetailScreen, page: () => const TransactionDetailDeferredScreen()),
      GetPage(name: baseWebViewScreen, page: () => BaseWebViewScreen()),
      GetPage(name: paymentWebViewScreen, page: () => const PaymentWebViewDeferredScreen()),
      GetPage(name: transactionHistoryDetailScreen, page: () => const TransactionHistoryDetailDeferredScreen()),
      GetPage(name: supportScreen, page: () => const SupportDeferredScreen()),
      GetPage(name: notificationScreen, page: () => NotificationScreen()),
      GetPage(name: campaignDetailScreen, page: () => CampaignDetailScreen()),
      GetPage(name: newsListScreen, page: () => const NewsListDeferredScreen()),
      GetPage(name: achievementListScreen, page: () => const AchievementListDeferredScreen()),
      GetPage(name: vplayGameCenterScreen, page: () => const VplayGameCenterDeferredScreen()),
      GetPage(name: myVoucherListScreen, page: () => const MyVoucherListDeferredScreen()),
      GetPage(name: personalEditScreen, page: () => PersonalEditScreen()),
      GetPage(name: orderMenuScreen, page: () => const OrderMenuDeferredScreen()),
      GetPage(name: locationAddressScreen, page: () => const LocationAddressDeferredScreen()),
      GetPage(name: membershipScreen, page: () => const MembershipDeferredScreen()),
      GetPage(name: phoneTopUpScreen, page: () => const PhoneTopUpDeferredScreen()),
      GetPage(name: productMobileCardScreen, page: () => const ProductMobileCardDeferredScreen()),
      GetPage(name: dataNetworkServiceScreen, page: () => const DataNetworkServiceDeferredScreen()),
      GetPage(name: affiliateTabScreen, page: () => const AffiliateTabDeferredScreen()),
      GetPage(name: gameTabScreen, page: () => const GameTabScreen()),
      GetPage(name: historyPointCashBackScreen, page: () => const HistoryPointCashBackDeferredScreen()),
      GetPage(name: affiliateBrandDetailScreen, page: () => const AffiliateBrandDetailDeferredScreen()),
      GetPage(name: affiliateBrandListScreen, page: () => const AffiliateBrandListDeferredScreen()),
      GetPage(name: affiliateCategoryGridScreen, page: () => const AffiliateCategoryGridDeferredScreen()),
      GetPage(name: inviteFriendCampaignScreen, page: () => const InviteFriendDeferredScreen()),
      GetPage(name: contactsListScreen, page: () => const ContactsListDeferredScreen()),
      GetPage(name: dailyCheckInScreen, page: () => const DailyCheckInDeferredScreen()),
      GetPage(name: transactionHistoryScreen, page: () => const TransactionHistoryDeferredScreen()),
      GetPage(name: electricPaymentScreen, page: () => const ElectricPaymentDeferredScreen()),
      GetPage(name: electricPaymentHistoryScreen, page: () => const ElectricPaymentHistoryDeferredScreen()),
      GetPage(name: trafficServiceScreen, page: () => const TrafficServiceDeferredScreen()),
      GetPage(name: trafficServiceDetailScreen, page: () => const TrafficServiceDetailDeferredScreen()),
      GetPage(name: campaignSevenDayScreen, page: () => const Campaign7DayDeferredScreen()),
      GetPage(name: surveyQuestionScreen, page: () => const SurveyQuestionDeferredScreen()),
      GetPage(name: deviceManagerScreen, page: () => const DeviceManagerDeferredScreen()),
      GetPage(name: myMobileCardListScreen, page: () => const MyMobileCardListDeferredScreen()),
      GetPage(name: interestCategoriesScreen, page: () => const InterestCategoriesDeferredScreen()),
      GetPage(name: bankAccountManagerScreen, page: () => const BankAccountManagerDeferredScreen()),
      GetPage(name: historyPointScreen, page: () => const HistoryPointDeferredScreen()),
      GetPage(name: qrCodeScreen, page: () => const QRCodeDeferredScreen()),
      GetPage(name: myMobileCardDetailScreen, page: () => const MyMobileCardDetailDeferredScreen()),
      GetPage(name: healthBookScreen, page: () => const HealthBookDeferredScreen()),
      GetPage(name: healthBookCardDetail, page: () => const HealthBookCardDetailDeferredScreen()),
      GetPage(name: notificationDetailScreen, page: () => NotificationDetailScreen()),
      GetPage(name: referralCodeInviteFriendScreen, page: () => const ReferralCodeInviteFriendDeferredScreen()),
      GetPage(name: campaignInviteReferralInfoScreen, page: () => const CampaignInviteReferralInfoDeferredScreen()),
      GetPage(name: accountManagerScreen, page: () => const AccountManagerScreen()),
    ];
  }
}