import 'package:dio/dio.dart';
import 'package:flutter/foundation.dart';
import 'package:mypoint_flutter_app/shared/navigate_helper.dart';

class ExceptionInterceptor extends Interceptor with navigateHelper {
  @override
  void onError(DioException err, ErrorInterceptorHandler handler) {
    switch (err.type) {
      case DioExceptionType.connectionTimeout:
      case DioExceptionType.receiveTimeout:
      case DioExceptionType.connectionError:
        showPopupErrorMessage("Kết nối mạng không ổn định.\nVui lòng thử lại!");
        break;
      default:
        return super.onError(err, handler);
    }
  }

  _handleStatusCode(int? statusCode) {
    switch (statusCode) {
      case 400:
        //FIXME
        print('Bad request.');
        break;
      case 401:
        //FIXME
        break;
      case 500:
        showPopupErrorMessage("Lỗi không xác định");
        break;
      default:
        if (kDebugMode) {
          print('Something went wrong');
        }
        break;
    }
  }
}
