import 'package:dio/dio.dart';
import 'package:logger/logger.dart';

class LoggerInterceptor extends Interceptor {
  Logger logger = Logger(
    // Customize the printer
    printer: PrettyPrinter(
      methodCount: 0,
      lineLength: 5000,
      printTime: false,
    ),
  );

  @override
  void onError(DioException err, ErrorInterceptorHandler handler) {
    final options = err.requestOptions;
    final requestPath = '${options.baseUrl}${options.path}';
    logger.e('${options.method} request => $requestPath\nError: ${err.error}, Message: ${err.message}');
    return super.onError(err, handler);
  }

  @override
  void onRequest(RequestOptions options, RequestInterceptorHandler handler) {
    final requestBody = options.data;
    final requestPath = '${options.baseUrl}${options.path}';
    final requestQuery = '${options.queryParameters}';
    final header = options.headers;
    logger.i('${options.method} request => $requestPath\nheader ===> $header\nquery ===> $requestQuery\nbody ==> $requestBody'); // Info log
    return super.onRequest(options, handler);
  }

  @override
  void onResponse(Response response, ResponseInterceptorHandler handler) {
    final options = response.requestOptions;
    final requestPath = '${options.baseUrl}${options.path}';
    logger.d('HTTPCode: ${response.statusCode}, URL: ${requestPath}\nData: ===> \n${response.data}'); // Debug log
    return super.onResponse(response, handler);
  }
}